package com.testor.module.safeCheck.model.domain;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 巡检结果明细(关联标准)对象 t_safe_hazard_check_result_detail
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:56
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_result_detail")
@ApiModel(value = "TSafeHazardCheckResultDetail对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckResultDetail extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;

/**
 * 排查结果id
 */
  @ApiModelProperty(value = "排查结果id")
  @TableField("result_id")
  private String resultId;

  @ApiModelProperty(value = "排查细则id")
  @TableField("option_id")
  private String optionId;

  @ApiModelProperty(value = "排查项id")
  @TableField("option_parent_id")
  private String optionParentId;

/**
 * 排查结果类型(关联排查结果类型表id)
 */
  @ApiModelProperty(value = "排查结果类型(关联排查结果类型表id)")
  @TableField("result_type_id")
  private String resultTypeId;
/**
 * 隐患id
 */
  @ApiModelProperty(value = "隐患id")
  @TableField("relation_id")
  private String relationId;

  public static final String ID ="id";
  public static final String CHECK_OBJ_ID ="check_obj_id";
  public static final String RESULT_ID ="result_id";
  public static final String NUM ="num";
  public static final String RESULT_TYPE_ID ="result_type_id";
  public static final String RELATION_ID ="relation_id";


}
