package com.testor.module.safeCheck.service;


import com.testor.module.safeCheck.model.domain.TSafeHazardCheckResultDetail;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckResultDetailParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultDetailCountVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultDetailVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 巡检结果明细(关联标准)Service接口
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:56
 */
public interface TSafeHazardCheckResultDetailService extends SuperService<TSafeHazardCheckResultDetail> {

    Boolean createResultDetail(String resultId, String standardId);

    List<SafeHazardCheckResultDetailVO> listByResult(String resultId);

    List<SafeHazardCheckResultDetailCountVO> countByResult(String resultId);

    List<TSafeHazardCheckResultDetail> listAllEntity(TSafeHazardCheckResultDetailParam param);

    /**
     *  修改巡检结果 值
     *  需要传id\result_type_id两个值
     *  当有 隐患上报时 需要 relationId(隐患id)
     */
    BaseResponse updateResultDetail(TSafeHazardCheckResultDetail resultDetail);

    /**
     *  修改巡检结果 值
     *  需要传id\result_type_id两个值
     *  当有 隐患上报时 需要 relationId(隐患id)
     */
    BaseResponse updateResultDetailList(List<TSafeHazardCheckResultDetail> resultDetailList);
    }
