package com.testor.module.train.myManagement.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 我的培训教育及考试—安全培训教育对象 t_train_my_management
 *
 * @author testor-framework
 * @date 2022-07-28 15:25:02
 */
@Data
@Accessors(chain = true)
@TableName("t_train_my_management_read")
@ApiModel(value = "t_train_my_management_read", description = "")
@AllArgsConstructor
@NoArgsConstructor
public class TTrainMyManagementRead {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "节点id")
    @TableField("node_id")
    private String nodeId;

    @ApiModelProperty(value = "1:已读")
    @TableField("read_status")
    private String readStatus;

    @ApiModelProperty(value = "完成时间")
    @TableField("finish_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;

    @ApiModelProperty(value = "学习人")
    @TableField("learner")
    private String learner;

    @ApiModelProperty(value = "学习方式 0集体 1自主")
    @TableField("learn_way")
    private String learnWay;

    @ApiModelProperty(value = "我的培训id")
    @TableField("management_id")
    private String managementId;
}
