package com.testor.module.video.dao;


import com.testor.module.video.model.domain.VideoDeviceNumber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 视频监控设备信息和粮库对应Mapper接口
 *
 * @author testor-framework
 * @date 2022-12-14 14:14:44
 */
@Repository
public class VideoDeviceNumberDao {

	@Autowired
	private VideoDeviceNumberMapper videoMapper;

	public void insertBatch(List<VideoDeviceNumber> userList) {
		videoMapper.insertBatchSomeColumn(userList);
	}

	public void clear() {
		videoMapper.clear();
	}

	public List<String> getDeviceIdByOrgId(String childrenOrgId) {
		return videoMapper.getDeviceIdByOrgId(childrenOrgId);
	}
}
