/*
 * Decompiled with CFR 0.152.
 */
package com.testor.xxl.job.task.util;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSON;
import com.cronutils.builder.CronBuilder;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.FieldExpressionFactory;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.testor.xxl.job.task.util.DateTimeUtil;
import com.testor.xxl.job.task.util.WeekdayEnum;
import java.sql.Time;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtil {
    private static final Logger log = LoggerFactory.getLogger(CronUtil.class);

    public static String generateCronByOne(LocalDateTime dateTime) {
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.on((int)year)).withDoM((FieldExpression)FieldExpressionFactory.on((int)day)).withMonth((FieldExpression)FieldExpressionFactory.on((int)month)).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByEveryHour(Integer second, Integer minute) {
        if (second == null || minute == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.always()).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByEveryDay(String startTime) {
        Time bidStartTime = DateTimeUtil.formatTime(startTime);
        if (bidStartTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u65e0\uff0c\u8f6c\u6362\u5931\u8d25");
        }
        int hour = bidStartTime.getHours();
        int minute = bidStartTime.getMinutes();
        int second = bidStartTime.getSeconds();
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.always()).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByEveryWeek(List<WeekdayEnum> weekdayEnumList, String startTime) {
        if (weekdayEnumList == null || weekdayEnumList.size() == 0) {
            return null;
        }
        ArrayList<On> dayExpressionList = new ArrayList<On>();
        for (WeekdayEnum weekdayEnum : weekdayEnumList) {
            dayExpressionList.add(weekdayEnum.getWeekday() == 7 ? FieldExpressionFactory.on((int)1) : FieldExpressionFactory.on((int)(weekdayEnum.getWeekday() + 1)));
        }
        Time bidStartTime = DateTimeUtil.formatTime(startTime);
        if (bidStartTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u65e0\uff0c\u8f6c\u6362\u5931\u8d25");
        }
        int hour = bidStartTime.getHours();
        int minute = bidStartTime.getMinutes();
        int second = bidStartTime.getSeconds();
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.questionMark()).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.and(dayExpressionList)).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByEveryMonth(List<Integer> monthdayArr, String startTime) {
        if (monthdayArr == null || monthdayArr.size() == 0) {
            return null;
        }
        ArrayList<On> dayExpressionList = new ArrayList<On>();
        for (Integer monthday : monthdayArr) {
            dayExpressionList.add(monthday == 0 ? FieldExpressionFactory.on((SpecialChar)SpecialChar.L) : FieldExpressionFactory.on((int)monthday));
        }
        Time bidStartTime = DateTimeUtil.formatTime(startTime);
        if (bidStartTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u65e0\uff0c\u8f6c\u6362\u5931\u8d25");
        }
        int hour = bidStartTime.getHours();
        int minute = bidStartTime.getMinutes();
        int second = bidStartTime.getSeconds();
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.and(dayExpressionList)).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByEveryYear(List<Integer> monthArr, List<Integer> dayArr, String startTime) {
        if (monthArr == null || monthArr.size() == 0 || dayArr == null || dayArr.size() == 0) {
            return null;
        }
        ArrayList<On> monthExpressionList = new ArrayList<On>();
        for (Integer n : monthArr) {
            monthExpressionList.add(FieldExpressionFactory.on((int)n));
        }
        ArrayList<On> dayExpressionList = new ArrayList<On>();
        for (Integer day : dayArr) {
            dayExpressionList.add(day == 0 ? FieldExpressionFactory.on((SpecialChar)SpecialChar.L) : FieldExpressionFactory.on((int)day));
        }
        Time time = DateTimeUtil.formatTime(startTime);
        if (time == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u65e0\uff0c\u8f6c\u6362\u5931\u8d25");
        }
        int hour = time.getHours();
        int minute = time.getMinutes();
        int second = time.getSeconds();
        Cron cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.and(dayExpressionList)).withMonth((FieldExpression)FieldExpressionFactory.and(monthExpressionList)).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static String generateCronByLastDay(List<Integer> monthArr, String startTime) {
        Cron cron;
        if (monthArr == null || monthArr.size() == 0) {
            return null;
        }
        Time bidStartTime = DateTimeUtil.formatTime(startTime);
        if (bidStartTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u65e0\uff0c\u8f6c\u6362\u5931\u8d25");
        }
        int hour = bidStartTime.getHours();
        int minute = bidStartTime.getMinutes();
        int second = bidStartTime.getSeconds();
        if (monthArr == null || monthArr.size() == 0) {
            cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.on((SpecialChar)SpecialChar.L)).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        } else {
            ArrayList<On> monthExpressionList = new ArrayList<On>();
            for (Integer month : monthArr) {
                monthExpressionList.add(FieldExpressionFactory.on((int)month));
            }
            cron = CronBuilder.cron((CronDefinition)CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ)).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.on((SpecialChar)SpecialChar.L)).withMonth((FieldExpression)FieldExpressionFactory.and(monthExpressionList)).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)hour)).withMinute((FieldExpression)FieldExpressionFactory.on((int)minute)).withSecond((FieldExpression)FieldExpressionFactory.on((int)second)).instance();
        }
        String cronAsString = cron.asString();
        log.info(cronAsString);
        return cronAsString;
    }

    public static ZonedDateTime calculateTime(String cronStr, Integer type) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        ZonedDateTime now = ZonedDateTime.now();
        log.info("now:" + JSON.toJSONString((Object)now));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronStr));
        Optional execution = null;
        ZonedDateTime calculateTime = null;
        if (type == 1) {
            execution = executionTime.lastExecution(now);
        }
        if (type == 2) {
            execution = executionTime.nextExecution(now);
        }
        if (execution == null || execution.equals(Optional.empty())) {
            return null;
        }
        calculateTime = (ZonedDateTime)execution.get();
        return calculateTime;
    }

    public static List<ZonedDateTime> calculateTimeList(String cronStr, LocalDateTime endDateTime) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronParser parser = new CronParser(cronDefinition);
        ZonedDateTime now = ZonedDateTime.now();
        log.info("now:" + JSON.toJSONString((Object)now));
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)parser.parse(cronStr));
        if (endDateTime == null) {
            endDateTime = LocalDateTimeUtil.offset((LocalDateTime)now.toLocalDateTime(), (long)2L, (TemporalUnit)ChronoUnit.YEARS);
        }
        List executionList = executionTime.getExecutionDates(now, endDateTime.atZone(ZoneId.of("Asia/Shanghai")));
        return executionList;
    }
}

