/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.error;

import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.response.ResponseUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GeneralErrorHandler
implements ErrorController {
    public String getErrorPath() {
        return "com/tongtech/tfw/backend/common/error";
    }

    @RequestMapping
    public void error(HttpServletRequest request, HttpServletResponse response) {
        HttpStatusCodeEnum errorCode;
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        switch (response.getStatus()) {
            case 400: {
                errorCode = HttpStatusCodeEnum.BAD_REQUEST;
                break;
            }
            case 401: {
                errorCode = HttpStatusCodeEnum.UNAUTHORIZED;
                break;
            }
            case 403: {
                errorCode = HttpStatusCodeEnum.FORBIDDEN;
                break;
            }
            case 404: {
                errorCode = HttpStatusCodeEnum.NOT_FOUND;
                break;
            }
            case 405: {
                errorCode = HttpStatusCodeEnum.METHOD_NOT_ALLOWED;
                break;
            }
            case 406: {
                errorCode = HttpStatusCodeEnum.NOT_ACCEPTABLE;
                break;
            }
            case 411: {
                errorCode = HttpStatusCodeEnum.LENGTH_REQUIRED;
                break;
            }
            case 415: {
                errorCode = HttpStatusCodeEnum.UNSUPPORTED_MEDIA_TYPE;
                break;
            }
            case 416: {
                errorCode = HttpStatusCodeEnum.REQUESTED_RANGE_NOT_SATISFIABLE;
                break;
            }
            case 503: {
                errorCode = HttpStatusCodeEnum.SERVICE_UNAVAILABLE;
                break;
            }
            default: {
                errorCode = HttpStatusCodeEnum.INTERNAL_SERVER_ERROR;
            }
        }
        ResponseUtil.response(request, response, errorCode, (Exception)request.getAttribute("javax.servlet.error.exception"));
    }
}

