/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.dependencies;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.util.ActionLogMsg;
import com.tongweb.web.util.res.StringManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class JSPMissWaringConfiguration {
    private static final Log log = LogFactory.getLog(JSPMissWaringConfiguration.class);
    private static final StringManager sm = StringManager.getManager((String)"com.tongweb.dependencies");
    private static AtomicBoolean isWaringFlag = new AtomicBoolean(false);

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.apache.jasper.servlet.JspServlet", "com.tongweb.container.startup.ServletContainer"})
    @ConditionalOnMissingClass(value={"com.tongweb.jasper.servlet.JspServlet"})
    protected static class JSPHandlerMissingClasspathConfiguration {
        public JSPHandlerMissingClasspathConfiguration() {
            if (!isWaringFlag.getAndSet(true)) {
                log.warn((Object)ActionLogMsg.infoMissing(sm.getString("tongweb.jsp.miss.message"), sm.getString("tongweb.jsp.miss.consider")));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"javax.servlet.jsp.JspPage", "com.tongweb.container.startup.ServletContainer"})
    @ConditionalOnMissingClass(value={"com.tongweb.jasper.servlet.JspServlet"})
    protected static class JSPMissingFromClasspathConfiguration {
        public JSPMissingFromClasspathConfiguration() {
            if (!isWaringFlag.getAndSet(true)) {
                log.warn((Object)ActionLogMsg.infoMissing(sm.getString("tongweb.jsp.miss.message"), sm.getString("tongweb.jsp.miss.consider")));
            }
        }
    }
}

