/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.position.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.position.JobPositionEnum;
import com.testor.biz.sys.position.model.domain.TSysJobPosition;
import com.testor.biz.sys.position.model.dto.TSysJobPositionDelParam;
import com.testor.biz.sys.position.model.dto.TSysJobPositionParam;
import com.testor.biz.sys.position.service.TSysJobPositionService;
import com.testor.biz.sys.userposition.service.TSysUserPositionService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/position"})
@Api(value="TSysJobPosition", tags={"SysJobPosition \u5c97\u4f4d"})
public class TSysJobPositionController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(TSysJobPositionController.class);
    @Autowired
    private TSysJobPositionService tSysJobPositionService;
    @Autowired
    private TSysUserPositionService tSysUserPositionService;

    @ApiOperation(value="\u65b0\u589e \u5c97\u4f4d", notes="\u65b0\u589e \u5c97\u4f4d Add TSysJobPosition")
    @PostMapping(value={"/add"})
    public BaseResponse<TSysJobPosition> addEntity(@RequestBody @Valid TSysJobPosition addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            int exited;
            if (StringHelper.isNotEmpty((CharSequence)addRequest.getPositionCode()) && 0 < (exited = this.tSysJobPositionService.count((Wrapper)new QueryWrapper().eq((Object)"position_code", (Object)addRequest.getPositionCode())))) {
                throw new ApiException(JobPositionEnum.EXISTED.transform());
            }
            String id = IdHelper.getId32bit();
            TSysJobPosition data = (TSysJobPosition)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), TSysJobPosition.class));
            data.setId(id);
            boolean result = this.tSysJobPositionService.save((Object)data);
            if (result) {
                TSysJobPosition newEntity = new TSysJobPosition();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u5c97\u4f4d ", notes="\u83b7\u53d6 \u5c97\u4f4d Get TSysJobPosition By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<TSysJobPosition> getById(String positionId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)positionId)) {
            TSysJobPosition data = (TSysJobPosition)((Object)this.tSysJobPositionService.getById((Serializable)((Object)positionId)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u5c97\u4f4d ", notes="\u4fee\u6539 \u5c97\u4f4d Update TSysJobPosition By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysJobPosition updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            int exited;
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getPositionCode()) && 0 < (exited = this.tSysJobPositionService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"position_code", (Object)updateRequest.getPositionCode())).ne((Object)"position_id", (Object)updateRequest.getId())))) {
                throw new ApiException(JobPositionEnum.EXISTED.transform());
            }
            TSysJobPosition data = (TSysJobPosition)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), TSysJobPosition.class));
            boolean result = this.tSysJobPositionService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u5c97\u4f4d ", notes="\u5220\u9664 \u5c97\u4f4d delete TSysJobPosition By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysJobPositionDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TSysJobPosition data = new TSysJobPosition();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            this.tSysUserPositionService.remove((Wrapper)new QueryWrapper().eq((Object)"position_id", (Object)deleteRequest.getId()));
            boolean result = this.tSysJobPositionService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5c97\u4f4d", notes="\u6279\u91cf\u5220\u9664\u5c97\u4f4d delete TSysJobPosition by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TSysJobPositionDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<TSysJobPosition> tSysJobPositionList = new ArrayList<TSysJobPosition>();
            for (String id : deleteRequest.getIds()) {
                TSysJobPosition data = new TSysJobPosition();
                data.setId(id);
                data.setStatus("1");
                tSysJobPositionList.add(data);
            }
            this.tSysUserPositionService.remove((Wrapper)new QueryWrapper().in((Object)"position_id", deleteRequest.getIds()));
            boolean result = this.tSysJobPositionService.updateBatchById(tSysJobPositionList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u5c97\u4f4d \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u5c97\u4f4d \u5206\u9875\u5217\u8868 List TSysJobPosition with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<TSysJobPosition>> listEntity(TSysJobPositionParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TSysJobPosition> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.tSysJobPositionService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u5c97\u4f4d \u5217\u8868", notes="\u83b7\u53d6 \u5c97\u4f4d \u5217\u8868 List TSysJobPosition all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<TSysJobPosition>> listAllEntity(TSysJobPositionParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TSysJobPosition> queryWrapper = this.createQuery(param);
        List resultList = this.tSysJobPositionService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<TSysJobPosition> createQuery(TSysJobPositionParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getPositionName())) {
            queryWrapper.like((Object)"position_name", (Object)queryParam.getPositionName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getPositionType())) {
            queryWrapper.eq((Object)"position_type", (Object)queryParam.getPositionType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrgId())) {
            queryWrapper.eq((Object)"org_id", (Object)queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getPositionCode())) {
            queryWrapper.eq((Object)"position_code", (Object)queryParam.getPositionCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

