/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.connector.Connector;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.starter.TongWebConnectorCustomizer;
import org.springframework.util.StringUtils;

class CompressionConnectorCustomizer
implements TongWebConnectorCustomizer {
    private final TongWebProperties tongWebProperties;

    CompressionConnectorCustomizer(TongWebProperties tongWebProperties) {
        this.tongWebProperties = tongWebProperties;
    }

    @Override
    public void customize(Connector connector) {
        if (this.tongWebProperties.getCompression() != null && this.tongWebProperties.getCompression().getEnabled()) {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                this.customize((AbstractHttp11Protocol)handler);
            }
            for (UpgradeProtocol upgradeProtocol : connector.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                this.customize((Http2Protocol)upgradeProtocol);
            }
        }
    }

    private void customize(Http2Protocol protocol) {
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize());
        protocol.setCompressibleMimeType(this.getMimeTypes());
        if (this.tongWebProperties.getCompression().getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize());
        protocol.setCompressibleMimeType(this.getMimeTypes());
        if (this.tongWebProperties.getCompression().getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private int getMinResponseSize() {
        return this.tongWebProperties.getCompression().getMinResponseSize();
    }

    private String getMimeTypes() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.tongWebProperties.getCompression().getMimeTypes());
    }

    private String getExcludedUserAgents() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.tongWebProperties.getCompression().getExcludedUserAgents());
    }
}

