/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.util.Utils;
import com.tongweb.container.webresources.Cache;
import com.tongweb.container.webresources.CachedResource;
import com.tongweb.container.webresources.EmptyResource;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.starter.TongWebEmbedCache;
import com.tongweb.springboot.starter.TongWebEmbedStandardRoot;
import com.tongweb.web.util.res.StringManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.security.Permission;
import java.security.cert.Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TongWebEmbedCachedResource
extends CachedResource {
    private static final Log log = LogFactory.getLog(TongWebEmbedCachedResource.class);
    private static final StringManager sm = StringManager.getManager(CachedResource.class);
    private static final long CACHE_ENTRY_SIZE = 500L;
    private final TongWebEmbedCache cache;
    private final TongWebEmbedStandardRoot root;
    private final String webAppPath;
    private final long ttl;
    private final int objectMaxSizeBytes;
    private final boolean usesClassLoaderResources;
    private volatile WebResource webResource;
    private volatile WebResource[] webResources;
    private volatile long nextCheck;
    private volatile Long cachedLastModified = null;
    private volatile String cachedLastModifiedHttp = null;
    private volatile byte[] cachedContent = null;
    private volatile Boolean cachedIsFile = null;
    private volatile Boolean cachedIsDirectory = null;
    private volatile Boolean cachedExists = null;
    private volatile Boolean cachedIsVirtual = null;
    private volatile Long cachedContentLength = null;

    public TongWebEmbedCachedResource(TongWebEmbedCache cache, TongWebEmbedStandardRoot root, String path, long ttl, int objectMaxSizeBytes, boolean usesClassLoaderResources) {
        super((Cache)cache, (StandardRoot)root, path, ttl, objectMaxSizeBytes, usesClassLoaderResources);
        this.cache = cache;
        this.root = root;
        this.webAppPath = path;
        this.ttl = ttl;
        this.objectMaxSizeBytes = objectMaxSizeBytes;
        this.usesClassLoaderResources = usesClassLoaderResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResource(boolean useClassLoaderResources) {
        if (this.usesClassLoaderResources != useClassLoaderResources) {
            return false;
        }
        long now = Utils.getCurrentTime();
        if (this.webResource == null) {
            TongWebEmbedCachedResource tongWebEmbedCachedResource = this;
            synchronized (tongWebEmbedCachedResource) {
                if (this.webResource == null) {
                    this.webResource = this.root.getTongWebResourceInternal(this.webAppPath, useClassLoaderResources);
                    this.getLastModified();
                    this.getContentLength();
                    this.nextCheck = this.ttl + now;
                    this.cachedExists = this.webResource instanceof EmptyResource ? Boolean.FALSE : Boolean.TRUE;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (!this.root.isPackedWarFile()) {
            WebResource webResourceInternal = this.root.getTongWebResourceInternal(this.webAppPath, useClassLoaderResources);
            if (!this.webResource.exists() && webResourceInternal.exists()) {
                return false;
            }
            if (this.webResource.getLastModified() != this.getLastModified() || this.webResource.getContentLength() != this.getContentLength()) {
                return false;
            }
            if (this.webResource.getLastModified() != webResourceInternal.getLastModified() || this.webResource.getContentLength() != webResourceInternal.getContentLength()) {
                return false;
            }
        }
        this.nextCheck = this.ttl + now;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResources(boolean useClassLoaderResources) {
        long now = Utils.getCurrentTime();
        if (this.webResources == null) {
            TongWebEmbedCachedResource tongWebEmbedCachedResource = this;
            synchronized (tongWebEmbedCachedResource) {
                if (this.webResources == null) {
                    this.webResources = this.root.getResourcesInternal(this.webAppPath, useClassLoaderResources);
                    this.nextCheck = this.ttl + now;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (this.root.isPackedWarFile()) {
            this.nextCheck = this.ttl + now;
            return true;
        }
        return false;
    }

    protected long getNextCheck() {
        return this.nextCheck;
    }

    public long getLastModified() {
        Long cachedLastModified = this.cachedLastModified;
        if (cachedLastModified == null) {
            this.cachedLastModified = cachedLastModified = Long.valueOf(this.webResource.getLastModified());
        }
        return cachedLastModified;
    }

    public String getLastModifiedHttp() {
        String cachedLastModifiedHttp = this.cachedLastModifiedHttp;
        if (cachedLastModifiedHttp == null) {
            this.cachedLastModifiedHttp = cachedLastModifiedHttp = this.webResource.getLastModifiedHttp();
        }
        return cachedLastModifiedHttp;
    }

    public boolean exists() {
        Boolean cachedExists = this.cachedExists;
        if (cachedExists == null) {
            this.cachedExists = cachedExists = Boolean.valueOf(this.webResource.exists());
        }
        return cachedExists;
    }

    public boolean isVirtual() {
        Boolean cachedIsVirtual = this.cachedIsVirtual;
        if (cachedIsVirtual == null) {
            this.cachedIsVirtual = cachedIsVirtual = Boolean.valueOf(this.webResource.isVirtual());
        }
        return cachedIsVirtual;
    }

    public boolean isDirectory() {
        Boolean cachedIsDirectory = this.cachedIsDirectory;
        if (cachedIsDirectory == null) {
            this.cachedIsDirectory = cachedIsDirectory = Boolean.valueOf(this.webResource.isDirectory());
        }
        return cachedIsDirectory;
    }

    public boolean isFile() {
        Boolean cachedIsFile = this.cachedIsFile;
        if (cachedIsFile == null) {
            this.cachedIsFile = cachedIsFile = Boolean.valueOf(this.webResource.isFile());
        }
        return cachedIsFile;
    }

    public boolean delete() {
        boolean deleteResult = this.webResource.delete();
        if (deleteResult) {
            this.cache.removeCacheEntry(this.webAppPath);
        }
        return deleteResult;
    }

    public String getName() {
        return this.webResource.getName();
    }

    public long getContentLength() {
        Long cachedContentLength = this.cachedContentLength;
        if (cachedContentLength == null) {
            long result = 0L;
            if (this.webResource != null) {
                result = this.webResource.getContentLength();
                this.cachedContentLength = cachedContentLength = Long.valueOf(result);
            }
            return result;
        }
        return cachedContentLength;
    }

    public String getCanonicalPath() {
        return this.webResource.getCanonicalPath();
    }

    public boolean canRead() {
        return this.webResource.canRead();
    }

    public String getWebappPath() {
        return this.webAppPath;
    }

    public String getETag() {
        return this.webResource.getETag();
    }

    public void setMimeType(String mimeType) {
        this.webResource.setMimeType(mimeType);
    }

    public String getMimeType() {
        return this.webResource.getMimeType();
    }

    public InputStream getInputStream() {
        byte[] content = this.getContent();
        if (content == null) {
            return this.webResource.getInputStream();
        }
        return new ByteArrayInputStream(content);
    }

    public void setContext(byte[] cachedContent) {
        this.cachedContent = cachedContent;
    }

    public byte[] getContent() {
        byte[] cachedContent = this.cachedContent;
        if (cachedContent == null) {
            if (this.getContentLength() > (long)this.objectMaxSizeBytes) {
                return null;
            }
            this.cachedContent = cachedContent = this.webResource.getContent();
        }
        return cachedContent;
    }

    public long getCreation() {
        return this.webResource.getCreation();
    }

    public URL getURL() {
        URL resourceURL = this.webResource.getURL();
        if (resourceURL == null) {
            return null;
        }
        try {
            CachedResourceURLStreamHandler handler = new CachedResourceURLStreamHandler(resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            URL result = new URL(null, resourceURL.toExternalForm(), handler);
            handler.setAssociatedURL(result);
            return result;
        }
        catch (MalformedURLException e) {
            log.error((Object)sm.getString("cachedResource.invalidURL", new Object[]{resourceURL.toExternalForm()}), (Throwable)e);
            return null;
        }
    }

    public URL getCodeBase() {
        return this.webResource.getCodeBase();
    }

    public Certificate[] getCertificates() {
        return this.webResource.getCertificates();
    }

    public Manifest getManifest() {
        return this.webResource.getManifest();
    }

    public WebResourceRoot getWebResourceRoot() {
        return this.webResource.getWebResourceRoot();
    }

    WebResource getWebResource() {
        return this.webResource;
    }

    WebResource[] getWebResources() {
        return this.webResources;
    }

    boolean usesClassLoaderResources() {
        return this.usesClassLoaderResources;
    }

    long getSize() {
        long result = 500L;
        result += (long)(this.getWebappPath().length() * 2);
        if (this.getContentLength() <= (long)this.objectMaxSizeBytes) {
            result += this.getContentLength();
        }
        return result;
    }

    private static InputStream buildInputStream(String[] files) {
        Arrays.sort(files, Collator.getInstance(Locale.getDefault()));
        StringBuilder result = new StringBuilder();
        for (String file : files) {
            result.append(file);
            result.append('\n');
        }
        return new ByteArrayInputStream(result.toString().getBytes(Charset.defaultCharset()));
    }

    private static class CachedResourceJarURLConnection
    extends JarURLConnection {
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceJarURLConnection(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) throws IOException {
            super(resourceURL);
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = resourceURL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                return TongWebEmbedCachedResource.buildInputStream(resource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return ((JarURLConnection)this.resourceURL.openConnection()).getJarFile();
        }

        @Override
        public JarEntry getJarEntry() throws IOException {
            if (this.getEntryName() == null) {
                return null;
            }
            return super.getJarEntry();
        }
    }

    private static class CachedResourceURLConnection
    extends URLConnection {
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceURLConnection(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            super(resourceURL);
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = resourceURL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                return TongWebEmbedCachedResource.buildInputStream(resource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }
    }

    private static class CachedResourceURLStreamHandler
    extends URLStreamHandler {
        private final URL resourceURL;
        private final TongWebEmbedStandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private URL associatedURL = null;

        public CachedResourceURLStreamHandler(URL resourceURL, TongWebEmbedStandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            this.resourceURL = resourceURL;
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
        }

        protected void setAssociatedURL(URL associatedURL) {
            this.associatedURL = associatedURL;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            if (this.associatedURL != null && u == this.associatedURL) {
                if ("jar".equals(this.associatedURL.getProtocol())) {
                    return new CachedResourceJarURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
                }
                return new CachedResourceURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            }
            URL constructedURL = new URL(u.toExternalForm());
            return constructedURL.openConnection();
        }
    }
}

