/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dv2.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dv2.model.domain.BladeVisualConfig;
import com.tongtech.tfw.dv2.model.dto.BladeVisualConfigDelParam;
import com.tongtech.tfw.dv2.model.dto.BladeVisualConfigParam;
import com.tongtech.tfw.dv2.service.BladeVisualConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/config"})
@Api(value="BladeVisualConfig", tags={"\u53ef\u89c6\u5316\u914d\u7f6e"})
public class BladeVisualConfigController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(BladeVisualConfigController.class);
    @Autowired
    private BladeVisualConfigService bladeVisualConfigService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u914d\u7f6e", notes="Add BladeVisualConfig")
    @PostMapping(value={"/add"})
    public BaseResponse<BladeVisualConfig> addEntity(@RequestBody BladeVisualConfig addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            String id = IdHelper.getId32bit();
            BladeVisualConfig data = (BladeVisualConfig)BeanHelper.beanToBean((Object)addRequest, BladeVisualConfig.class);
            data.setId(id);
            boolean result = this.bladeVisualConfigService.save(data);
            if (result) {
                BladeVisualConfig newEntity = new BladeVisualConfig();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="Get BladeVisualConfig By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<BladeVisualConfig> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            BladeVisualConfig data = (BladeVisualConfig)this.bladeVisualConfigService.getById((Serializable)((Object)id));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="Update BladeVisualConfig By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody BladeVisualConfig updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            BladeVisualConfig data = (BladeVisualConfig)BeanHelper.beanToBean((Object)updateRequest, BladeVisualConfig.class);
            boolean result = this.bladeVisualConfigService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u914d\u7f6e ", notes="delete BladeVisualConfig By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody BladeVisualConfigDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            BladeVisualConfig data = new BladeVisualConfig();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.bladeVisualConfigService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u914d\u7f6e", notes="delete BladeVisualConfig by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody BladeVisualConfigDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<BladeVisualConfig> bladeVisualConfigList = new ArrayList<BladeVisualConfig>();
            for (String id : deleteRequest.getIds()) {
                BladeVisualConfig data = new BladeVisualConfig();
                data.setId(id);
                data.setStatus("1");
                bladeVisualConfigList.add(data);
            }
            boolean result = this.bladeVisualConfigService.updateBatchById(bladeVisualConfigList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5206\u9875\u5217\u8868", notes="List BladeVisualConfig with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<BladeVisualConfig>> listEntity(BladeVisualConfigParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<BladeVisualConfig> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.bladeVisualConfigService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u914d\u7f6e \u5217\u8868", notes="List BladeVisualConfig all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<BladeVisualConfig>> listAllEntity(BladeVisualConfigParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<BladeVisualConfig> queryWrapper = this.createQuery(param);
        List resultList = this.bladeVisualConfigService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<BladeVisualConfig> createQuery(BladeVisualConfigParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectHelper.isNotEmpty((Object)queryParam.getVisualId())) {
            queryWrapper.eq((Object)"visual_id", (Object)queryParam.getVisualId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDetail())) {
            queryWrapper.eq((Object)"detail", (Object)queryParam.getDetail());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getComponent())) {
            queryWrapper.eq((Object)"component", (Object)queryParam.getComponent());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"id");
        }
        return queryWrapper;
    }
}

