package com.testor.ddd.safetyControl.application.service.riskPointManage;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.TSafeRiskPointVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.exception.BusinessException;

public interface RiskPointManageService {
    /**
     * 编辑空间
     * @param riskPointDto
     * @return
     */
    BaseResponse editRiskPoint(TSafeRiskPointDTO riskPointDto) throws BusinessException;

    BaseResponseList<TSafeRiskPointVO> listByPage(TSafeRiskPointDTOParam param);

    TSafeRiskPointDTO findById(String id);

    BaseResponse deleteById(String id) throws BusinessException;

    TSafeRiskPointVO findDetailById(String id);

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    boolean deleteBySpaceOrEquipment(Integer type, String bizId);

    TSafeRiskPointDTO findBySource(String sourceId);

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String orgId, String pointId, String name);

    TSafeRiskPointDTO save(TSafeRiskPointDTO pointDTO);
}
