package com.testor.ddd.safetyControl.infrastructure.repository.riskSource.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.infrastructure.repository.riskSource.entity.TSafeRiskSourceDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceUpdatedVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 危险源Mapper接口
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
public interface TSafeRiskSourceDao extends SuperDao<TSafeRiskSourceDO>
{
    /**
     * 分页查询
     * @param param
     * @return
     */
    IPage<TSafeRiskSourceVO> listPage(Page<TSafeRiskSourceVO> page, @Param("query") TSafeRiskSourceDTOParam param);

    /**
     * 修改记录分页查询
     * @param param
     * @return
     */
    IPage<TSafeRiskSourceUpdatedVO> listPageByUpdated(Page<TSafeRiskSourceUpdatedVO> page, @Param("query") TSafeRiskSourceDTOParam param);

    /**
     * 查询危险源导出数据列表
     * @param param
     * @return
     */
    List<TSafeRiskSourceVO> listExpData(@Param("query") TSafeRiskSourceDTOParam param);

}
