package com.testor.module.ZLOA.sysOrgOA.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 组织机构(OA)对象 t_sys_org_oa
 * 
 * @author testor-framework
 * @date 2022-09-13 09:57:13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_org_oa")
@ApiModel(value = "TSysOrgOa对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysOrgOa extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 机构表主键
 */
  @ApiModelProperty(value = "机构表主键")

  @TableId("org_id")
  private String orgId;
/**
 * 父级机构主键，如果是顶级节点值为0
 */
  @ApiModelProperty(value = "父级机构主键，如果是顶级节点值为0")

  @TableField("parent_id")
  private String parentId;
/**
 * 所有父级机构主键以英文逗号隔开如：一级，二级等
 */
  @ApiModelProperty(value = "所有父级机构主键以英文逗号隔开如：一级，二级等")

  @TableField("parent_ids")
  private String parentIds;
/**
 * 排序号
 */
  @ApiModelProperty(value = "排序号" , example = "0")

  @TableField("tree_sort")
  private Long treeSort;
/**
 * 层次级别，1顶级依次类推
 */
  @ApiModelProperty(value = "层次级别，1顶级依次类推" , example = "0")

  @TableField("tree_level")
  private Long treeLevel;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 机构编码
 */
  @ApiModelProperty(value = "机构编码")

  @TableField("org_code")
  private String orgCode;
/**
 * 联系地址
 */
  @ApiModelProperty(value = "联系地址")

  @TableField("address")
  private String address;
/**
 * 邮政编码
 */
  @ApiModelProperty(value = "邮政编码")

  @TableField("zip_code")
  private String zipCode;
/**
 * 负责人
 */
  @ApiModelProperty(value = "负责人")

  @TableField("leader")
  private String leader;
/**
 * 电话
 */
  @ApiModelProperty(value = "电话")

  @TableField("phone_no")
  private String phoneNo;
/**
 * 传真
 */
  @ApiModelProperty(value = "传真")

  @TableField("fax")
  private String fax;
/**
 * 邮箱
 */
  @ApiModelProperty(value = "邮箱")

  @TableField("email")
  private String email;
/**
 * 是否部门  1部门 0 机构
 */
  @ApiModelProperty(value = "是否部门  1部门 0 机构")

  @TableField("is_dept")
  private String isDept;
/**
 * 所在省
 */
  @ApiModelProperty(value = "所在省")

  @TableField("province")
  private String province;
/**
 * 所在市
 */
  @ApiModelProperty(value = "所在市")

  @TableField("city")
  private String city;
/**
 * 所在县
 */
  @ApiModelProperty(value = "所在县")

  @TableField("county")
  private String county;


  public static final String ORG_ID ="org_id";
  public static final String PARENT_ID ="parent_id";
  public static final String PARENT_IDS ="parent_ids";
  public static final String TREE_SORT ="tree_sort";
  public static final String TREE_LEVEL ="tree_level";
  public static final String ORG_NAME ="org_name";
  public static final String ORG_CODE ="org_code";
  public static final String ADDRESS ="address";
  public static final String ZIP_CODE ="zip_code";
  public static final String LEADER ="leader";
  public static final String PHONE_NO ="phone_no";
  public static final String FAX ="fax";
  public static final String EMAIL ="email";
  public static final String IS_DEPT ="is_dept";
  public static final String PROVINCE ="province";
  public static final String CITY ="city";
  public static final String COUNTY ="county";

  @JsonIgnore
  public String getId(){
  	return this.orgId;
  }
  @JsonIgnore
  public void setId(String orgId){
  	this.orgId = orgId;
  }

}
