package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 承包商信息对象 t_contractor_info
 * 
 * @author testor-framework
 * @date 2024-11-22 13:41:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_info")
@ApiModel(value = "TContractorInfo对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorInfo extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 承包商名称
 */
  @ApiModelProperty(value = "承包商名称")

  @TableField("name")
  private String name;
/**
 * 统一社会信用代码
 */
  @ApiModelProperty(value = "统一社会信用代码")

  @TableField("credit_code")
  private String creditCode;
/**
 * 注册资本
 */
  @ApiModelProperty(value = "注册资本" , example = "0")

  @TableField("reg_capital")
  private String regCapital;
/**
 * 所在省
 */
  @ApiModelProperty(value = "所在省")

  @TableField("province")
  private String province;
/**
 * 所在市
 */
  @ApiModelProperty(value = "所在市")

  @TableField("city")
  private String city;
/**
 * 详细地址
 */
  @ApiModelProperty(value = "详细地址")

  @TableField("addr")
  private String addr;
/**
 * 企业法人代表
 */
  @ApiModelProperty(value = "企业法人代表")

  @TableField("legal_person")
  private String legalPerson;
/**
 * 企业法人电话
 */
  @ApiModelProperty(value = "企业法人电话")

  @TableField("tel")
  private String tel;
/**
 * 成立时间
 */
  @ApiModelProperty(value = "成立时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("reg_date")
  private Date regDate;
/**
 * 有效期限
 */
  @ApiModelProperty(value = "有效期限")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("valid_period")
  private Date validPeriod;
/**
 * 经营范围
 */
  @ApiModelProperty(value = "经营范围")

  @TableField("biz_scope")
  private String bizScope;

  /**
   * 是否黑名单
   */
  @ApiModelProperty(value = "是否黑名单")

  @TableField("is_blacklist")
  private String isBlacklist;

  public static final String ID ="id";
  public static final String NAME ="name";
  public static final String CREDIT_CODE ="credit_code";
  public static final String REG_CAPITAL ="reg_capital";
  public static final String PROVINCE ="province";
  public static final String CITY ="city";
  public static final String ADDR ="addr";
  public static final String LEGAL_PERSON ="legal_person";
  public static final String TEL ="tel";
  public static final String REG_DATE ="reg_date";
  public static final String VALID_PERIOD ="valid_period";
  public static final String BIZ_SCOPE ="biz_scope";
  public static final String IS_BLACKLIST ="is_blacklist";

}
