package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDictConvert;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 应急物资导入模板对象
 */
@Data
public class EmergencyMaterialTemplate {
    /**
     * 应急物资名称
     */
    @ExcelProperty(value = "应急物资名称",index = 0)
    @NotBlank(message = "应急物资名称不能为空")
    @ColumnWidth(value = 20)
    private String name;

    /**
     * 类型
     */
    @ExcelProperty(value = "类型",converter = ExcelDictConvert.class,index = 1)
    @ExcelDictFormat(dictType = "contractor_emergency_material_type")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_emergency_material_type")
    @NotBlank(message = "类型不能为空")
    @ColumnWidth(value = 20)
    private String typeId;

    /**
     * 数量
     */
    @ExcelProperty(value = "数量",index = 2)
    @NotNull(message = "数量不能为空")
    @Min(value = 1,message = "数量不能小于1")
    @Max(value = 99999L,message = "数量不能大于99999")
    @ColumnWidth(value = 20)
    private Long num;
    /**
     * 用途
     */
    @ExcelProperty(value = "用途",index = 3)
    @NotBlank(message = "用途不能为空")
    @ColumnWidth(value = 20)
    private String purpose;
    /**
     * 存放地点
     */
    @ExcelProperty(value = "存放地点",index = 4)
    @NotBlank(message = "存放地点不能为空")
    @ColumnWidth(value = 20)
    private String storageLocation;
    /**
     * 责任人
     */
    @ExcelProperty(value = "责任人",index = 5)
    @NotBlank(message = "责任人不能为空")
    @ColumnWidth(value = 20)
    private String respPerson;
    /**
     * 联系电话
     */
    @ExcelProperty(value = "联系电话",index = 6)
    @NotBlank(message = "联系方式不能为空")
    @ColumnWidth(value = 20)
    private String tel;

    @ExcelProperty(value = "备注",index = 7)
    @ColumnWidth(value = 20)
    private String remarks;
}
