package com.testor.module.duty.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 值班抽查对象 t_sys_selective
 * 
 * @author testor-framework
 * @date 2022-06-06 10:06:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_selective")
@ApiModel(value = "TSysSelective对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysSelective extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 关联id
 */
  @ApiModelProperty(value = "关联id")

  @TableField("ref_id")
  private String refId;
/**
 * 父级id
 */
  @ApiModelProperty(value = "父级id")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 企业id
 */
  @ApiModelProperty(value = "企业id")

  @TableField("company_id")
  private String companyId;
/**
 * 抽查人
 */
  @ApiModelProperty(value = "抽查人")

  @TableField("selective_person")
  private String selectivePerson;
/**
 * 部门名称
 */
  @ApiModelProperty(value = "部门名称")

  @TableField("dept_name")
  private String deptName;
/**
 * 抽查时间
 */
  @ApiModelProperty(value = "抽查时间")

  @TableField("check_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date checkTime;
/**
 * 作业情况
 */
  @ApiModelProperty(value = "作业情况")

  @TableField("work_case")
  private String workCase;
/**
 * 存在问题
 */
  @ApiModelProperty(value = "存在问题")

  @TableField("exist_issue")
  private String existIssue;
/**
 * 抽查方式
 */
  @ApiModelProperty(value = "抽查方式")

  @TableField("pattern")
  private String pattern;
/**
 * 抽查人员照片

 */
  @ApiModelProperty(value = "抽查人员照片 ")

  @TableField("check_person_photo")
  private String checkPersonPhoto;
/**
 * 存在问题照片
 */
  @ApiModelProperty(value = "存在问题照片")

  @TableField("issue_photo")
  private String issuePhoto;
/**
 * 值班人员
 */
  @ApiModelProperty(value = "值班人员")

  @TableField("duty_operator")
  private String dutyOperator;
/**
 * 值班人员id
 */
  @ApiModelProperty(value = "值班人员id")

  @TableField("duty_operator_id")
  private String dutyOperatorId;
/**
 * 人员归属
 */
  @ApiModelProperty(value = "人员归属")

  @TableField("unit_belong")
  private String unitBelong;
/**
 * 企业名称
 */
  @ApiModelProperty(value = "企业名称")

  @TableField("company_name")
  private String companyName;
/**
 * 租户名称
 */
  @ApiModelProperty(value = "租户名称")

  @TableField("tenant_name")
  private String tenantName;

  /**
   * 是否存在问题
   */
  @ApiModelProperty(value = "是否存在问题，1 有问题，0 没有问题")
  @TableField("is_issue")
  private String isIssue;

  /**
   * 值班日期
   */
  @ApiModelProperty(value = "值班日期")
  @TableField("duty_date")
  private String dutyDate ;

  @ApiModelProperty(value = "抽查单位id")
  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String COMPANY_ID ="company_id";
  public static final String SELECTIVE_PERSON ="selective_person";
  public static final String DEPT_NAME ="dept_name";
  public static final String CHECK_TIME ="check_time";
  public static final String WORK_CASE ="work_case";
  public static final String EXIST_ISSUE ="exist_issue";
  public static final String PATTERN ="pattern";
  public static final String CHECK_PERSON_PHOTO ="check_person_photo";
  public static final String ISSUE_PHOTO ="issue_photo";
  public static final String DUTY_OPERATOR ="duty_operator";
  public static final String DUTY_OPERATOR_ID ="duty_operator_id";
  public static final String UNIT_BELONG ="unit_belong";
  public static final String COMPANY_NAME ="company_name";
  public static final String TENANT_NAME ="tenant_name";
  public static final String IS_ISSUE ="is_issue";
  public static final String DUTY_DATE ="duty_date";
  public static final String ORG_ID ="org_id";


}
