package com.testor.module.hazard.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;
import com.testor.module.hazard.model.dto.HazardWorkPlanCheckStatsDTO;
import com.testor.module.hazard.model.dto.THazardWorkPlanCheckParam;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckComplianceStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckDetail;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemCountStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemTypeStatisticsVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTask;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 危险作业计划监督检查Mapper接口
 *
 * @author testor-framework
 * @date 2025-04-16 10:09:22
 */
public interface THazardWorkPlanCheckDao extends SuperDao<THazardWorkPlanCheck> {

    /**
     * 查询危险作业计划监督检查列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectTHazardWorkPlanCheckList(IPage page, @Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * App查询危险作业计划监督检查列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectAppTHazardWorkPlanCheckList(IPage page, @Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * App查询危险作业计划监督检查管理列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectTHazardWorkPlanCheckManageList(IPage page, @Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * App查询危险作业计划监督检查管理列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    List<THazardWorkPlanCheck> selectTHazardWorkPlanCheckManageExportList(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 查询危险作业计划监督检查详情
     * @param id
     * @return
     */
    THazardWorkPlanCheck detail(String id);

    /**
     * 查询危险计划下的监督检查数量
     * @param planId
     * @return
     */
    @Select("select count(1) from t_hazard_work_plan_check\n" +
            "where plan_id = #{planId} and status ='0'")
    Integer countByPlanId(String planId);

    /**
     * 监督检查合规率统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckComplianceStatisticsVO> selectCheckComplianceStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 监督检查问题类型统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckProblemTypeStatisticsVO> selectCheckProblemTypeStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     *问题数量统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckProblemCountStatisticsVO> selectCheckProblemCountStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 获取危险作业计划检查统计
     */
    HazardWorkPlanCheckStatsDTO selectHazardWorkPlanCheckStats(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 查询符合条件的危险作业计划检查数量
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    Integer selectComplianceCount(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 查询不符合条件的危险作业计划检查数量
     * @param orgId
     * @param startTime
     * @param endTime
     * @return
     */
    Double selectNoComplianceCount(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam,@Param("problemType") String problemType);

    /**
     * 企业合规率
     * @param orgId
     * @param startTime
     * @param endTime
     * @param basicId
     * @return
     */
    Page<HazardWorkPlanCheckProblemCountStatisticsVO> corporateComplianceRate(@Param("page") IPage page,@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 企业合规率详情之危险作业状态统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckDetail> workStatusStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 企业合规率详情之组织机构类型抽查率/合规率 统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckDetail> isRentSpotCheckStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 企业合规率详情之组织机构类型抽查率/合规率 统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckDetail> comprehensiveStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 企业合规率详情之作业级别合规率统计
     * @param tHazardWorkPlanCheckParam
     * @return
     *//*
    List<HazardWorkPlanCheckDetail> complianceRateStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    *//**
     * 企业合规率详情之组织机构类型合规率统计
     * @param tHazardWorkPlanCheckParam
     * @return
     *//*
    List<HazardWorkPlanCheckDetail> isRentComplianceRateStatistics(@Param("param") THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);*/



}
