package com.testor.module.hazard.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class THazardWorkPlanTemplate {

    @ExcelProperty("序号")
    private String number;

    @ExcelProperty("作业编号")
    private String code;

    @ExcelProperty("单位名称")
    private String orgName;

    @ExcelProperty(value = "作业单位")
    private String workUnitName;

    @ExcelProperty(value = "作业内容")
    private String workContent;

    @ExcelProperty(value = "作业地点")
    private String workLocation;

    @ExcelProperty(value = "作业类型",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "dange_work_type")
    private String workType;

    @ExcelProperty(value = "作业级别",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "dange_work_level")
    private String workLevel;

    @ExcelProperty(value = "相关方作业",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "dange_work_stakeholder_work")
    private String stakeholderWork;

    @ExcelProperty(value = "作业现场负责人")
    private String workSiteResponsibleName;

    @ExcelProperty(value = "监护人")
    private String guardianName;

    @ExcelProperty(value = "监督人")
    private String supervisorName;

    @ExcelProperty(value = "作业人")
    private String operatorName;
    /**
     * 交底人
     */
    @ExcelProperty(value = "交底人")
    private String discloserName;

    @ExcelProperty(value = "作业所在单位")
    private String operationUnitName;

    @ExcelProperty(value = "作业主管单位")
    private String workSupervisoryUnitName;

    @ExcelProperty(value = "计划作业开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduledStartTime;

    @ExcelProperty(value = "计划作业结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduledEndTime;

    @ExcelProperty(value = "实际作业开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualStartTime;

    @ExcelProperty(value = "实际作业结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualEndTime;

    @ExcelProperty(value = "作业状态",converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=草稿,1=作业前（风险分析）,2=作业前（条件确认）,3=作业前（许可证）,4=技术交底,5=已关闭,6=已取消,7=已超时,8=驳回,9=审批中,10=进行中")
    private String workStatus;

    @ExcelProperty(value = "申请人")
    private String createByName;
}
