package com.testor.module.hazard.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;
import com.testor.module.hazard.model.dto.HazardWorkPlanCheckEnterpriseComplianceDto;
import com.testor.module.hazard.model.dto.HazardWorkPlanCheckStatsDTO;
import com.testor.module.hazard.model.dto.THazardWorkPlanCheckParam;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckComplianceStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckDetail;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemCountStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemTypeStatisticsVO;
import com.testor.module.safe.model.dto.TSafeHazardOrgParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 危险作业计划监督检查Service接口
 * 
 * @author testor-framework
 * @date 2025-04-16 10:09:22
 */
public interface THazardWorkPlanCheckService extends SuperService<THazardWorkPlanCheck> {

    /**
     * 查询危险作业计划监督检查列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectTHazardWorkPlanCheckList(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * App查询危险作业计划监督检查列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectAppTHazardWorkPlanCheckList(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 查询危险作业计划监督检查管理列表
     *
     * @param tHazardWorkPlanCheckParam 危险作业计划监督检查主键
     * @return 危险作业计划监督检查
     */
    Page<THazardWorkPlanCheck> selectTHazardWorkPlanCheckManageList(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 新增危险作业监督检查
     * @param addRequest
     * @return
     */
    THazardWorkPlanCheck addEntity(THazardWorkPlanCheck addRequest);

    /**
     * 查询危险作业计划监督检查详情
     * @param id
     * @return
     */
    THazardWorkPlanCheck detail(String id);

    /**
     * 导出PC端监督检查管理列表
     * @param param
     * @param response
     * @return
     */
    void exportEntity(THazardWorkPlanCheckParam param, HttpServletResponse response);


    /**
     * 监督检查合规率统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckComplianceStatisticsVO> selectCheckComplianceStatistics(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 监督检查问题类型统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckProblemTypeStatisticsVO> selectCheckProblemTypeStatistics(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     *问题数量统计
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    List<HazardWorkPlanCheckProblemCountStatisticsVO> selectCheckProblemCountStatistics(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 获取危险作业计划检查统计
     */
    HazardWorkPlanCheckStatsDTO selectHazardWorkPlanCheckStats(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 企业合规数
     * @param userId
     * @param startTime
     * @param endTime
     * @return
     */
    List<HazardWorkPlanCheckEnterpriseComplianceDto> enterpriseComplianceNumber(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);

    /**
     * 问题数量统计
     * @param userId
     * @param startTime
     * @param endTime
     * @return
     */
    List<HazardWorkPlanCheckProblemCountStatisticsVO> selectProblemCountStatistics(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 企业合规率
     * @param userId
     * @param startTime
     * @param endTime
     * @param basicId
     * @return
     */
    Page<HazardWorkPlanCheckProblemCountStatisticsVO> corporateComplianceRate(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


    /**
     * 危险作业详表
     * @param tHazardWorkPlanCheckParam
     * @return
     */
    Page<HazardWorkPlanCheckDetail> detailsOfHazardousOperations(THazardWorkPlanCheckParam tHazardWorkPlanCheckParam);


}
