package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.core.utils.StringUtils;
import com.testor.common.util.BeanConverUtil;
import com.testor.module.hazard.dao.THazardLicenseDao;
import com.testor.module.hazard.model.domain.THazardLicense;
import com.testor.module.hazard.model.domain.THazardLicenseAnalysisInfo;
import com.testor.module.hazard.model.domain.THazardLicenseSignatureRecord;
import com.testor.module.hazard.model.domain.THazardLicenseSiteConfirmation;
import com.testor.module.hazard.model.dto.THazardLicenseDTO;
import com.testor.module.hazard.model.dto.THazardWorkPlanDTO;
import com.testor.module.hazard.service.*;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 危险作业-许可证信息Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-12-31 17:24:34
 */
@Service
public class THazardLicenseServiceImpl extends SuperServiceImpl<THazardLicenseDao, THazardLicense> implements THazardLicenseService
{
    @Autowired(required = false)
    private THazardLicenseDao tHazardLicenseDao;
    @Autowired
    private THazardLicenseAnalysisInfoService tHazardLicenseAnalysisInfoService;
    @Autowired
    private THazardWorkPlanService tHazardWorkPlanService;
    @Autowired
    private THazardLicenseSignatureRecordService tHazardLicenseSignatureRecordService;
    @Autowired
    private THazardLicenseSiteConfirmationService tHazardLicenseSiteConfirmationService;

    @Override
    public THazardLicense saveOrUpdateEntity(THazardLicenseDTO addRequest) {
        THazardLicense data= BeanHelper.beanToBean(addRequest,  THazardLicense.class);
        List<THazardLicense> tHazardLicenses = this.list(new QueryWrapper<THazardLicense>()
                .eq(THazardLicense.PLAN_ID, addRequest.getPlanId())
                .ne(StringUtils.isNotBlank(addRequest.getId()), THazardLicense.ID, addRequest.getId()));
        if (!tHazardLicenses.isEmpty()) {
            throw new RuntimeException("许可证已存在");
        }
        this.saveOrUpdate(data);
        String id = data.getId();
        tHazardLicenseAnalysisInfoService.remove(new QueryWrapper<THazardLicenseAnalysisInfo>().eq(THazardLicenseAnalysisInfo.LICENSE_ID, id));
        for (THazardLicenseAnalysisInfo analysisInfo : addRequest.getTHazardLicenseAnalysisInfoList()) {
            analysisInfo.setLicenseId(id);
            analysisInfo.setId(IdHelper.getId32bit());
            tHazardLicenseAnalysisInfoService.save(analysisInfo);
        }
        if (addRequest.getTHazardLicenseSignatureRecordList() != null) {
            // 签名记录
            for (THazardLicenseSignatureRecord tHazardLicenseSignatureRecord : addRequest.getTHazardLicenseSignatureRecordList()) {
                tHazardLicenseSignatureRecord.setLicenseId(id);
                tHazardLicenseSignatureRecordService.saveOrUpdate(tHazardLicenseSignatureRecord);
            }
        }
        if (addRequest.getTHazardLicenseSiteConfirmations() != null) {
            // 现场确认
            for (THazardLicenseSiteConfirmation tHazardLicenseSiteConfirmation : addRequest.getTHazardLicenseSiteConfirmations()) {

                tHazardLicenseSiteConfirmation.setLicenseId(id);
                tHazardLicenseSiteConfirmationService.saveOrUpdate(tHazardLicenseSiteConfirmation);
            }
        }
        return data;
    }

    @Override
    public THazardLicenseDTO getDetailedById(String planId) {
        List<THazardLicense> tHazardLicenses = this.list(new QueryWrapper<THazardLicense>().eq(THazardLicense.PLAN_ID, planId).orderByAsc("create_date"));
        if (tHazardLicenses != null && !tHazardLicenses.isEmpty()) {
            THazardLicense tHazardLicense = tHazardLicenses.get(0);
            THazardLicenseDTO tHazardLicenseDTO = BeanConverUtil.conver(tHazardLicense, THazardLicenseDTO.class);
            //分析信息
            tHazardLicenseDTO.setTHazardLicenseAnalysisInfoList(tHazardLicenseAnalysisInfoService.list(new QueryWrapper<THazardLicenseAnalysisInfo>().eq(THazardLicenseAnalysisInfo.LICENSE_ID, tHazardLicense.getId())));
            //计划详情
            THazardWorkPlanDTO detailsById = tHazardWorkPlanService.getDetailsById(planId);
            tHazardLicenseDTO.setTHazardWorkPlanDTO(detailsById);
            //查询签字记录
            List<THazardLicenseSignatureRecord> tHazardLicenseSignatureRecordList = tHazardLicenseSignatureRecordService.list(
                    new QueryWrapper<THazardLicenseSignatureRecord>()
                    .eq(THazardLicenseSignatureRecord.LICENSE_ID, tHazardLicense.getId())
                    .orderByDesc("create_date"));
            tHazardLicenseDTO.setTHazardLicenseSignatureRecordList(tHazardLicenseSignatureRecordList);
            //现场确认记录
            List<THazardLicenseSiteConfirmation> tHazardLicenseSiteConfirmations = tHazardLicenseSiteConfirmationService.list(new QueryWrapper<THazardLicenseSiteConfirmation>()
                    .eq(THazardLicenseSiteConfirmation.LICENSE_ID, tHazardLicense.getId())
                    .orderByDesc("create_date"));
            tHazardLicenseDTO.setTHazardLicenseSiteConfirmations(tHazardLicenseSiteConfirmations);
            return tHazardLicenseDTO;
        }
        return null;
    }
}
