package com.testor.module.safe.model.dto;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 隐患巡检排查标准细则对象 t_safe_hazard_option
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:44
 */
@Data
@ApiModel(value = "TSafeHazardOptionEditDTO 对象", description = "")
public class TSafeHazardOptionEditDTO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;

    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String processStatus;
    /**
     * 检查项名称
     */
    @ApiModelProperty(value = "检查项名称")
    private String checkName;
    /**
     * 检查项类别（1-大类；2-小类）
     */
    @ApiModelProperty(value = "检查项类别（1-大类；2-小类）")
    private String checkType;
    /**
     * 检查项细则id（小类时有值）
     */
    @ApiModelProperty(value = "检查项细则id（小类时有值）废止不用")
    private String checkId;
    /**
     * 检查细则内容
     */
    @ApiModelProperty(value = "检查细则内容")
    private String checkContent;
    /**
     * 检查方法
     */
    @ApiModelProperty(value = "检查方法")
    private String checkMethod;

    @ApiModelProperty(value = "具体细则")
    private List<TSafeHazardOptionEditDTO> tSafeHazardOptionEditDTOList;
}
