package com.testor.module.video.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 视频监控设备信息和粮库对应对象 t_video_device_number
 *
 * @author testor-framework
 * @date 2022-12-14 14:14:44
 */
@Data
@Accessors(chain = true)
@TableName("t_video_device_number")
@ApiModel(value = "VideoDeviceNumber对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class VideoDeviceNumber{
	private static final long serialVersionUID = 1L;
	/**
	 * 主键ID
	 */
	@ApiModelProperty(value = "主键ID")
	@TableId("id")
	private String id;
	/**
	 * 粮库id（系统内id）
	 */
	@ApiModelProperty(value = "粮库id（系统内id）")
	@TableField("org_id")
	private String orgId;
	/**
	 * 粮库名称
	 */
	@ApiModelProperty(value = "粮库名称")

	@TableField("org_name")
	private String orgName;
	/**
	 * 粮库简称
	 */
	@ApiModelProperty(value = "粮库简称")

	@TableField("org_short_name")
	private String orgShortName;
	/**
	 * 监控设备编号
	 */
	@ApiModelProperty(value = "监控设备编号")

	@TableField("device_id")
	private String deviceId;
	/**
	 * 粮库信息编码
	 */
	@ApiModelProperty(value = "粮库信息编码")

	@TableField("camera_code")
	private String cameraCode;
	/**
	 * 设备名称
	 */
	@ApiModelProperty(value = "设备名称")

	@TableField("camera_name")
	private String cameraName;
	/**
	 * 监控地址
	 */
	@ApiModelProperty(value = "监控地址")

	@TableField("camera_position")
	private String cameraPosition;
	/**
	 * 监控设备类型
	 */
	@ApiModelProperty(value = "监控设备类型")

	@TableField("camera_type")
	private String cameraType;

	@TableField("status")
	private String status;

	public static final String ID = "id";
	public static final String ORG_ID = "org_id";
	public static final String ORG_NAME = "org_name";
	public static final String ORG_SHORT_NAME = "org_short_name";
	public static final String DEVICE_ID = "device_id";
	public static final String CAMERA_CODE = "camera_code";
	public static final String CAMERA_NAME = "camera_name";
	public static final String CAMERA_POSITION = "camera_position";
	public static final String CAMERA_TYPE = "camera_type";

}
