package com.testor.workflow.config;


import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.security.DefaultPrivileges;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Aspect  // 使用@Aspect注解声明一个切面
@Component
public class ModelsResourceAspect {

//    public final String userPointCut = "execution(* org.flowable.ui.modeler.serviceapi.ModelService.createModel(..))&& args(modelRepresentation, json, user)";
//    @Before(value=userPointCut,argNames="modelRepresentation, json, user")
//    public void runBefore(ModelRepresentation modelRepresentation, String json, User user){
//        System.out.println("ModelsResourceAspect runBefore()执行前执行了！！！！！");
//            if(user == null) {
//                user = new RemoteUser();
//            }
//            user.setId("admin22");
//            user.setDisplayName("Administrator22");
//    }


    @Pointcut("execution(* org.flowable.ui.modeler.serviceapi.ModelService.createModel(..))")
    public void createModelPointCut() {
    }

    @Around("createModelPointCut()")
    public Object runBefore(ProceedingJoinPoint  joinPoint){
        System.out.println("ModelsResourceAspect runBefore()执行前执行了！！！！！");

        try {
            Object[] args = joinPoint.getArgs();
            if(args.length == 2 || args[2] == null) {
                RemoteUser user = new RemoteUser();
                user.setId("admin");
                user.setDisplayName("Administrator");
                user.setFirstName("Administrator");
                user.setLastName("Administrator");
                user.setEmail("admin@flowable.com");
                user.setPassword("123456");
                List<String> pris = new ArrayList<>();
                pris.add(DefaultPrivileges.ACCESS_MODELER);
                pris.add(DefaultPrivileges.ACCESS_IDM);
                pris.add(DefaultPrivileges.ACCESS_ADMIN);
                pris.add(DefaultPrivileges.ACCESS_TASK);
                pris.add(DefaultPrivileges.ACCESS_REST_API);
                user.setPrivileges(pris);
                args[2] = user;
            }
            Object result = joinPoint.proceed(args);
            return result;
        }catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}


