/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.miniws.util;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiJDKBase64Util {
    private static final Logger log = Logger.getLogger(MultiJDKBase64Util.class.getName());

    public static boolean isJDK1point7() {
        String version = System.getProperty("java.version");
        return version != null && version.startsWith("1.7");
    }

    public static byte[] decode(String data) {
        byte[] content;
        block4: {
            content = new byte[]{};
            try {
                if (MultiJDKBase64Util.isJDK1point7()) {
                    Class<?> aClass = MultiJDKBase64Util.class.getClassLoader().loadClass("javax.xml.bind.DatatypeConverter");
                    Method parseBase64Binary = aClass.getMethod("parseBase64Binary", String.class);
                    content = (byte[])parseBase64Binary.invoke(aClass, data);
                } else {
                    Class<?> aClass = MultiJDKBase64Util.class.getClassLoader().loadClass("java.util.Base64");
                    Method getEncoder = aClass.getMethod("getDecoder", new Class[0]);
                    Object decodeObj = getEncoder.invoke(aClass, new Object[0]);
                    Class<?> decodeClass = decodeObj.getClass();
                    Method decode = decodeClass.getMethod("decode", byte[].class);
                    content = (byte[])decode.invoke(decodeObj, new Object[]{data.getBytes()});
                }
            }
            catch (Exception e2) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.fine("decode msg is error " + e2.getMessage() + " input data:" + data);
            }
        }
        return content;
    }

    public static String encode(byte[] inData) {
        String content;
        block4: {
            content = null;
            try {
                if (MultiJDKBase64Util.isJDK1point7()) {
                    Class<?> aClass = MultiJDKBase64Util.class.getClassLoader().loadClass("javax.xml.bind.DatatypeConverter");
                    Method parseBase64Binary = aClass.getMethod("printBase64Binary", byte[].class);
                    content = (String)parseBase64Binary.invoke(aClass, new Object[]{inData});
                } else {
                    Class<?> aClass = MultiJDKBase64Util.class.getClassLoader().loadClass("java.util.Base64");
                    Method getEncoder = aClass.getMethod("getEncoder", new Class[0]);
                    Object encodeObj = getEncoder.invoke(aClass, new Object[0]);
                    Class<?> encoderClass = encodeObj.getClass();
                    Method encode = encoderClass.getMethod("encode", byte[].class);
                    byte[] ecodeResult = (byte[])encode.invoke(encodeObj, new Object[]{inData});
                    content = new String(ecodeResult);
                }
            }
            catch (Exception e2) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.fine("encode msg is error " + e2.getMessage() + " input data:" + new String(inData));
            }
        }
        return content;
    }
}

