/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.rule.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.rule.RuleEnum;
import com.testor.biz.rule.model.domain.SysRule;
import com.testor.biz.rule.model.dto.SysRuleDelParam;
import com.testor.biz.rule.model.dto.SysRuleParam;
import com.testor.biz.rule.service.SysRuleService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rule"})
@Api(value="SysRule", tags={"SysRule \u6570\u636e\u89c4\u5219\u6743\u9650"})
public class SysRuleController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysRuleController.class);
    @Autowired
    private SysRuleService sysRuleService;

    @ApiOperation(value="\u65b0\u589e \u6570\u636e\u89c4\u5219\u6743\u9650", notes="\u65b0\u589e \u6570\u636e\u89c4\u5219\u6743\u9650 Add SysRule")
    @PostMapping(value={"/add"})
    public BaseResponse<SysRule> addEntity(@RequestBody @Valid SysRule addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            int count;
            if (StringHelper.isNotEmpty((CharSequence)addRequest.getRuleCode()) && 0 < (count = this.sysRuleService.count((Wrapper)new QueryWrapper().eq((Object)"rule_code", (Object)addRequest.getRuleCode())))) {
                throw new ApiException(RuleEnum.EXISTED.transform());
            }
            String id = IdHelper.getId32bit();
            SysRule data = (SysRule)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), SysRule.class));
            data.setId(id);
            data = this.sysRuleService.generateSqlTemplate(data);
            if (StringHelper.isEmpty((CharSequence)data.getRuleSqlTemplate())) {
                throw new ApiException(RuleEnum.PARAM_ERROR.transform());
            }
            boolean result = this.sysRuleService.save((Object)data);
            if (result) {
                SysRule newEntity = new SysRule();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u6570\u636e\u89c4\u5219\u6743\u9650 ", notes="\u83b7\u53d6 \u6570\u636e\u89c4\u5219\u6743\u9650 Get SysRule By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysRule> getById(String ruleId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)ruleId)) {
            SysRule data = (SysRule)((Object)this.sysRuleService.getById((Serializable)((Object)ruleId)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u6570\u636e\u89c4\u5219\u6743\u9650 ", notes="\u4fee\u6539 \u6570\u636e\u89c4\u5219\u6743\u9650 Update SysRule By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody SysRule updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            int count;
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getRuleCode()) && 0 < (count = this.sysRuleService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"rule_code", (Object)updateRequest.getRuleCode())).ne((Object)"rule_id", (Object)updateRequest.getRuleId())))) {
                throw new ApiException(RuleEnum.EXISTED.transform());
            }
            SysRule data = (SysRule)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), SysRule.class));
            data.setUpdateBy(this.getUserId());
            data = this.sysRuleService.generateSqlTemplate(data);
            if (StringHelper.isEmpty((CharSequence)data.getRuleSqlTemplate())) {
                throw new ApiException(RuleEnum.PARAM_ERROR.transform());
            }
            boolean result = this.sysRuleService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u6570\u636e\u89c4\u5219\u6743\u9650 ", notes="\u5220\u9664 \u6570\u636e\u89c4\u5219\u6743\u9650 delete SysRule By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody SysRuleDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            SysRule data = new SysRule();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.sysRuleService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u89c4\u5219\u6743\u9650", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u89c4\u5219\u6743\u9650 delete SysRule by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody SysRuleDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<SysRule> sysRuleList = new ArrayList<SysRule>();
            for (String id : deleteRequest.getIds()) {
                SysRule data = new SysRule();
                data.setId(id);
                data.setStatus("1");
                sysRuleList.add(data);
            }
            boolean result = this.sysRuleService.updateBatchById(sysRuleList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u6570\u636e\u89c4\u5219\u6743\u9650 \u5206\u9875\u5217\u8868", notes="List SysRule with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysRule>> listEntity(SysRuleParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysRule> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysRuleService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u6570\u636e\u89c4\u5219\u6743\u9650 \u5217\u8868", notes="List SysRule all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<SysRule>> listAllEntity(SysRuleParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysRule> queryWrapper = this.createQuery(param);
        List resultList = this.sysRuleService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysRule> createQuery(SysRuleParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleCode())) {
            queryWrapper.eq((Object)"rule_code", (Object)queryParam.getRuleCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleName())) {
            queryWrapper.like((Object)"rule_name", (Object)queryParam.getRuleName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleType())) {
            queryWrapper.eq((Object)"rule_type", (Object)queryParam.getRuleType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleDataCode())) {
            queryWrapper.eq((Object)"rule_data_code", (Object)queryParam.getRuleDataCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleDataOperation())) {
            queryWrapper.eq((Object)"rule_data_operation", (Object)queryParam.getRuleDataOperation());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleDataScope())) {
            queryWrapper.eq((Object)"rule_data_scope", (Object)queryParam.getRuleDataScope());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRuleSqlTemplate())) {
            queryWrapper.eq((Object)"rule_sql_template", (Object)queryParam.getRuleSqlTemplate());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

