/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.reactive;

import com.tongtech.commons.utils.StringUtils;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.reactive.ReactiveTongWebServerFactoryCustomizer;
import com.tongweb.springboot.reactive.ReactiveTongWebWebServerFactoryConfiguration;
import com.tongweb.springboot.reactive.TongWebReactiveWebServerFactoryCustomizer;
import java.util.Locale;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.adapter.ForwardedHeaderTransformer;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnClass(value={ReactiveHttpInputMessage.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={TongWebProperties.class})
@Import(value={BeanPostProcessorsRegistrar.class, ReactiveTongWebWebServerFactoryConfiguration.EmbeddedTongWeb.class})
public class ReactiveTongWebWebServerFactoryAutoConfiguration {
    @Bean
    public ReactiveTongWebServerFactoryCustomizer reactiveTongWebWebServerFactoryCustomizer(@Qualifier(value="server-com.tongweb.springboot.properties.TongWebProperties") TongWebProperties serverProperties) {
        String language = serverProperties.getTongweb().getLanguage();
        String country = serverProperties.getTongweb().getCountry();
        if (StringUtils.isEmpty((Object)language)) {
            Locale.setDefault(Locale.US);
        } else {
            Locale.setDefault(new Locale(language, country));
        }
        return new ReactiveTongWebServerFactoryCustomizer(serverProperties);
    }

    @Bean
    @ConditionalOnClass(name={"com.tongweb.container.startup.ServletContainer"})
    public TongWebReactiveWebServerFactoryCustomizer tongWebReactiveWebServerFactoryCustomizer(@Qualifier(value="server-com.tongweb.springboot.properties.TongWebProperties") TongWebProperties serverProperties) {
        return new TongWebReactiveWebServerFactoryCustomizer(serverProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"server.forward-headers-strategy"}, havingValue="framework")
    public ForwardedHeaderTransformer forwardedHeaderTransformer() {
        return new ForwardedHeaderTransformer();
    }

    public static class BeanPostProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            this.registerSyntheticBeanIfMissing(registry, "webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class, WebServerFactoryCustomizerBeanPostProcessor::new);
        }

        private <T> void registerSyntheticBeanIfMissing(BeanDefinitionRegistry registry, String name, Class<T> beanClass, Supplier<T> instanceSupplier) {
            if (ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForType(beanClass, true, false))) {
                RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass, instanceSupplier);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
        }
    }
}

