/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper;

import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.File;
import java.nio.charset.Charset;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressHelper {
    private static final Logger log = LoggerFactory.getLogger(CompressHelper.class);

    public static String zip(String source, String dest, String password) {
        return CompressHelper.zip(new File(source), dest, password, CompressionMethod.DEFLATE, CompressionLevel.NORMAL);
    }

    public static String zip(File source, String dest, String password, CompressionMethod compressionMethod, CompressionLevel compressionLevel) {
        String finalPath;
        try {
            if (!source.exists()) {
                throw new FrameworkException("Compress Error: File Not Found");
            }
            ZipFile zipFile = new ZipFile(CompressHelper.buildDestFile(source, dest));
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(compressionMethod);
            zipParameters.setCompressionLevel(compressionLevel);
            if (StringHelper.isNotBlank(password)) {
                zipParameters.setEncryptFiles(true);
                zipParameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                zipFile.setPassword(password.toCharArray());
            }
            if (source.isDirectory()) {
                zipFile.addFolder(source, zipParameters);
            } else {
                zipFile.addFile(source, zipParameters);
            }
            finalPath = zipFile.getFile().getAbsolutePath();
        }
        catch (ZipException z) {
            log.error("Compress Exception: ", (Throwable)z);
            throw new FrameworkException(z.getMessage());
        }
        return finalPath;
    }

    public static String zip(File source, String dest, String password, long fileSize, CompressionMethod compressionMethod, CompressionLevel compressionLevel) throws ZipException {
        if (!source.exists()) {
            throw new FrameworkException("Compress Error: File Not Found");
        }
        ZipFile zipFile = new ZipFile(CompressHelper.buildDestFile(source, dest));
        ZipParameters parameters = new ZipParameters();
        if (StringHelper.isNotBlank(password)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            zipFile.setPassword(password.toCharArray());
        }
        parameters.setCompressionMethod(compressionMethod);
        parameters.setCompressionLevel(compressionLevel);
        if (fileSize == 0L) {
            fileSize = Long.MAX_VALUE;
        }
        zipFile.createSplitZipFileFromFolder(source, parameters, true, fileSize);
        String finalPath = zipFile.getFile().getAbsolutePath();
        return finalPath;
    }

    public static String unzip(String zipFile, String dest, String password) {
        return CompressHelper.unzip(new File(zipFile), dest, password, Charset.defaultCharset());
    }

    public static String unzip(File source, String dest, String password, Charset charset) {
        String finalPath;
        try {
            File destFile;
            ZipFile zipFile = new ZipFile(source);
            if (!zipFile.isValidZipFile()) {
                throw new FrameworkException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u65e0\u6548,\u53ef\u80fd\u5df2\u7ecf\u635f\u574f.");
            }
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password.toCharArray());
            }
            if ((destFile = new File(dest)).isDirectory() && !destFile.exists()) {
                destFile.mkdir();
            }
            zipFile.setCharset(charset);
            zipFile.extractAll(dest);
            finalPath = destFile.getAbsolutePath();
        }
        catch (ZipException e) {
            log.error("Compress Exception: ", (Throwable)e);
            throw new FrameworkException(StringHelper.isNotBlank(e.getType().name()) ? e.getType().name() : e.getMessage());
        }
        return finalPath;
    }

    private static File buildDestFile(File source, String dest) {
        if (StringHelper.isBlank(dest)) {
            dest = source.isDirectory() ? source.getParent() + File.separator + source.getName() + ".zip" : source.getParent() + File.separator + source.getName().substring(0, source.getName().lastIndexOf(".")) + ".zip";
            File destFile = new File(dest);
            return destFile;
        }
        CompressHelper.createDestPath(dest);
        if (dest.endsWith(File.separator)) {
            dest = source.isDirectory() ? dest + source.getName() + ".zip" : dest + source.getName().substring(0, source.getName().lastIndexOf(".")) + ".zip";
        }
        File destFile = new File(dest);
        return destFile;
    }

    private static void createDestPath(String dest) {
        File destPath = dest.endsWith(File.separator) ? new File(dest) : new File(dest.substring(0, dest.lastIndexOf(File.separator)));
        if (!destPath.exists()) {
            destPath.mkdir();
        }
    }
}

