package com.testor.common.annotation;

import java.lang.annotation.*;

/**
 * 标注导出的列为下拉框类型，并为下拉框设置内容
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ExcelSelected {
    /**
     * 固定下拉内容
     */
    String[] source() default {};


    /**
     * 类型 (需与实现类上的 {@link com.testor.common.annotation.ExcelSelectedType} 注解type对应)
     * <p>
     */
    String type() default "";

    /**
     * 参数 可以是字典type 可以是机构id,可扩展
     * <p>
     */
    String param() default "";


    /**
     * 设置下拉框的起始行，默认为第二行
     */
    int firstRow() default 1;

    /**
     * 设置下拉框的结束行，默认为最后一行
     */
    int lastRow() default 0x10000;
}
