package com.testor.ddd.safetyControl.application.service.spaceManage;

import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.testor.module.notice.model.domain.TreeVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface SpaceManageService {
    /**
     * 编辑空间
     * @param spaceOrgDto
     * @return
     */
    BaseResponse editSpace(TSafeSpaceDTO spaceOrgDto);

    BaseResponseList<TSafeSpaceVO> listByPage(TSafeSpaceDTOParam param);

    /**
     * 根据编码查询
     * @param code
     * @return
     */
    List<TSafeSpaceVO> listByCode(String code);

    TSafeSpaceDTO findById(String id);

    /**
     *
     * @param type 1-车间场所，2-作业区域
     * @param id
     * @return
     */
    BaseResponse deleteById(Integer type, String id);


    /**
     * 通过空间场所类型删除
     * @param spaceTypeId
     * @return
     */
    boolean deleteBySpaceType(String spaceTypeId);

    Integer replaceCode(String spaceTypeId, String oldCode, String newCode);

    BaseResponse<String> importWorkshop(MultipartFile file) throws IOException;

    BaseResponse<String> importWorkarea(MultipartFile file) throws IOException;

    //更具类型id查询空间场所信息
    List<TSafeSpaceDTO> findBySpaceTypeId(String id);

    List<TSafeSpaceDTO> selectList(String orgId);

    /**
     * 作业活动区域书
     * @param orgId
     * @return
     */
    List<TreeVO> getTree(String orgId);

    TSafeSpaceDTO findBySpaceName(String name,String orgId);
    List<TSafeSpaceVO> listSafeSpaceAll(TSafeSpaceDTOParam param);
}
