package com.testor.ddd.safetyControl.application.service.spaceManage.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceManageService;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceTypeManageService;
import com.testor.ddd.safetyControl.domain.space.entity.TSafeSpaceTypeRepo;
import com.testor.ddd.safetyControl.domain.space.service.SpaceTypeService;
import com.testor.ddd.safetyControl.infrastructure.client.funConfClient.TableNumClient;
import com.testor.ddd.safetyControl.infrastructure.uitls.GenerateCode;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTOParam;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class SpaceTypeManageServiceImpl implements SpaceTypeManageService {

    @Resource
    private SpaceTypeService spaceTypeService;

    @Resource
    private TSafeSpaceTypeRepo tSafeSpaceTypeRepo;

    @Resource
    private SpaceManageService spaceManageService;

    @Resource
    private TableNumClient tableNumClient;

    @Resource
    private GenerateCode generateCode;

    /**
     * 编辑空间
     *
     * @param spaceTypeDto
     * @return
     */
    @Transactional
    public BaseResponse editSpaceType(TSafeSpaceTypeDTO spaceTypeDto) {
        BaseResponse baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        if(StrUtil.isBlank(spaceTypeDto.getName()) ||
            StrUtil.isBlank(spaceTypeDto.getCode())){
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("参数缺失");
            return baseResponse;
        }

        String curUserOrgId = curUser.getOrgId();
        spaceTypeDto.setOrgId(curUserOrgId);

        String id = spaceTypeDto.getId();
        String fieldNameOld = null;
        if(!StrUtil.isBlank(id)) {
            String oldCode = tSafeSpaceTypeRepo.findById(id).getCode();
            if(!spaceTypeDto.getCode().equals(oldCode)) {
                TSafeSpaceDTO spaceDTOOld = new TSafeSpaceDTO();
                spaceDTOOld.setLevel(1);
                spaceDTOOld.setOrgId(curUserOrgId);
                spaceDTOOld.setSpaceTypeId(id);
                fieldNameOld = generateCode.generateSpaceTableNumFieldName(spaceDTOOld);
            }
        }

        baseResponse = spaceTypeService.editSpaceType(curUser.getUserId(), curUserOrgId, spaceTypeDto);

        if (!StrUtil.isBlank(fieldNameOld) && BaseStatusEnum.SUCCESS.code() == baseResponse.getCode().intValue()) {
            // 逻辑待续 车间类型编号变化 同时 修改 t_table_num表中的 fieldName的值
            TSafeSpaceDTO spaceDTONew = new TSafeSpaceDTO();
            spaceDTONew.setLevel(1);
            spaceDTONew.setOrgId(curUserOrgId);
            spaceDTONew.setSpaceTypeId(spaceTypeDto.getId());
            String fieldNameNew = generateCode.generateSpaceTableNumFieldName(spaceDTONew);

            tableNumClient.replaceFieldName("t_safe_space", fieldNameOld, fieldNameNew);
            spaceManageService.replaceCode(id, fieldNameOld, fieldNameNew);
        }
        return baseResponse;
    }


    public BaseResponseList<TSafeSpaceTypeDTO> listByPage(TSafeSpaceTypeDTOParam param) {
//        UserInfo curUser = ContextUtils.getLoginUser();
//        String curUserOrgId = curUser.getOrgId();
//        param.setOrgId(curUserOrgId);

        return spaceTypeService.listByPage(param);
    }

    public TSafeSpaceTypeDTO findById(String id) {
        return tSafeSpaceTypeRepo.findById(id);
    }

    @Transactional
    public BaseResponse deleteById(String id) {
        BaseResponse baseResponse = new BaseResponse<>();
        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        String curUserOrgId = curUser.getOrgId();
        TSafeSpaceTypeDTO oldSpaceTypeDto = tSafeSpaceTypeRepo.findById(id);
        if (!curUserOrgId.equals(oldSpaceTypeDto.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UNAUTHORIZED.code());
            baseResponse.setMsg("无权限操作");
            return baseResponse;
        }

        oldSpaceTypeDto.setStatus(BizConstants.STATUS_DELETE);
        int result = tSafeSpaceTypeRepo.updateById(oldSpaceTypeDto);
        if(result < 1) {
            return baseResponse;
        }

         //*  删除车间场所类型下的 所有车间场所、作业区域
        spaceManageService.deleteBySpaceType(id);

        return baseResponse;
    }

    @Override
    public List<TSafeSpaceTypeDTO> selectList() {
        return spaceTypeService.myList();
    }
}
