package com.testor.ddd.safetyControl.infrastructure.repository.space.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.infrastructure.repository.space.entity.TSafeSpaceDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 空间场所Mapper接口
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:21
 */
public interface TSafeSpaceDao extends SuperDao<TSafeSpaceDO>
{
    /**
     * 车间场所分页查询
     * @param param
     * @return
     */
    IPage<TSafeSpaceVO> listPageByWorkshop(Page<TSafeSpaceVO> page, @Param("query") TSafeSpaceDTOParam param);

    /**
     * 作业区域分页查询
     * @param param
     * @return
     */
    IPage<TSafeSpaceVO> listPageByWorkArea(Page<TSafeSpaceVO> page, @Param("query") TSafeSpaceDTOParam param);
    /**
     * 作业区域查询
     * @param param
     * @return
     */
    List<TSafeSpaceVO> listPageByWorkArea( @Param("query") TSafeSpaceDTOParam param);

    /**
     * 根据编码查询
     * @param spaceCode
     * @return
     */
    List<TSafeSpaceVO> listByCode(@Param("spaceCode") String spaceCode);


    /**
     * 根id查询空间场所名称 /类型/空间/作业区域
     * @param spaceId
     * @return
     */
    TSafeSpaceVO getSpaceNameById(@Param("spaceId") String spaceId);

    Integer replaceCode(@Param("spaceTypeId") String tableName, @Param("oldCode") String oldCode, @Param("newCode") String newCode);

    List<TSafeSpaceVO> listSafeSpaceAll( @Param("query") TSafeSpaceDTOParam param);

}
