package com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 危险点(风险分级)对象 t_safe_risk_point
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:14
 */
@Data
public class RiskPointSourceVO implements Serializable
{
  @ApiModelProperty(value = "风险点危险源id")
  private String pointSourceId;

  @ApiModelProperty(value = "危险源id")
  private String sourceId;

  @ApiModelProperty(value = "危险源名称")
  private String sourceName;

  @ApiModelProperty(value = "固有风险等级id")
  private String inherentLevelId;

  @ApiModelProperty(value = "固有风险等级名称")
  private String inherentLevelName;

  @ApiModelProperty(value = "固有风险等级key")
  private String inherentLevelKey;

  @ApiModelProperty(value = "现实风险等级id")
  private String realLevelId;

  @ApiModelProperty(value = "现实风险等级名称")
  private String realLevelName;

  @ApiModelProperty(value = "现实风险等级key")
  private String realLevelKey;

  @ApiModelProperty(value = "管控层级id")
  private String controlLevelId;

  @ApiModelProperty(value = "管控层级名称")
  private String controlLevelName;

  @ApiModelProperty(value = "管控层级key")
  private String controlLevelKey;

  @Override
  public boolean equals(Object o) {
    if (o instanceof RiskPointSourceVO) {
      RiskPointSourceVO pointSource = (RiskPointSourceVO) o;
      return this.sourceId.equals(pointSource.sourceId);
    }
    return super.equals(o);
  }
}
