package com.testor.module.aptitude.controller;

import java.util.ArrayList;
import java.util.List;

import com.testor.biz.rule.service.SysRuleService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.common.constant.DefaultRule;
import com.testor.module.aptitude.model.domain.TPersonAptitudeDto;
import com.testor.module.aptitude.model.dto.DataStatistics;
import com.testor.module.sys.service.TOrgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.TypeHelper;

import com.testor.module.aptitude.model.domain.TPersonAptitude;
import com.testor.module.aptitude.model.dto.TPersonAptitudeParam;
import com.testor.module.aptitude.model.dto.TPersonAptitudeDelParam;
import com.testor.module.aptitude.service.TPersonAptitudeService;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 人员资质管理Controller
 *
 * @author testor-framework
 * @date 2022-07-20 18:05:48
 */
@RestController
@RequestMapping("/aptitude")
@Api(value = "TPersonAptitude", tags = "人员资质管理")
@Slf4j
public class TPersonAptitudeController extends SuperController {
    @Autowired
    private TPersonAptitudeService tPersonAptitudeService;
    @Autowired
    private TOrgService tOrgService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRuleService sysRuleService;

    @ApiOperation(value = "获取已经添加过的资质", notes = "需要传部门id  和 人员id")
    @GetMapping(value = "/getAptitude")
    public BaseResponse<List<TPersonAptitude>> getAptitude(TPersonAptitude addRequest) {
        return tPersonAptitudeService.getAptitude(addRequest);
    }

    /* Generated Method*/
    @ApiOperation(value = "新增 人员资质管理", notes = "Add TPersonAptitude")
    @PostMapping(value = "/add")
    public BaseResponse<TPersonAptitude> addEntity(@RequestBody TPersonAptitudeParam addRequest) throws Exception {
        return tPersonAptitudeService.addEntity(addRequest);
    }

    @ApiOperation(value = "获取 人员资质管理 ", notes = "Get TPersonAptitude By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TPersonAptitudeDto> getById(String id) {
        return tPersonAptitudeService.getByIds(id);
    }

    @ApiOperation(value = "修改 人员资质管理 ", notes = "Update TPersonAptitude By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TPersonAptitude updateRequest) throws Exception {
        return tPersonAptitudeService.updateEntity(updateRequest);
    }

    @ApiOperation(value = "删除 人员资质管理 ", notes = "delete TPersonAptitude By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TPersonAptitudeDelParam deleteRequest) {
        return tPersonAptitudeService.deleteEntity(deleteRequest);
    }

    @ApiOperation(value = "资质数据统计 人员资质管理 ", notes = "")
    @PostMapping(value = "/AptitudeStatistics")
    public BaseResponse<List<DataStatistics>> AptitudeStatistics(@RequestBody TPersonAptitudeParam addRequest) {
        return tPersonAptitudeService.AptitudeStatistics(addRequest);
    }

    @ApiOperation(value = "资质状态修改  人员资质管理 ", notes = "")
    @PostMapping(value = "/AptitudeStatus")
    public BaseResponse<BizGeneralResponse> AptitudeStatus() {
        return tPersonAptitudeService.AptitudeStatus();
    }

    @ApiOperation(value = "资质信息批量导入 人员资质管理 ", notes = "")
    @PostMapping(value = "/AptitudeExport")
    public BaseResponse<BizGeneralResponse> AptitudeExport(@RequestParam("file") MultipartFile file) throws Exception {
        return tPersonAptitudeService.AptitudeExport(file);
    }

    //    @ApiOperation(value = "批量删除人员资质管理", notes = "delete TPersonAptitude by batch Id")
//    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TPersonAptitudeDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TPersonAptitude> tPersonAptitudeList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TPersonAptitude data = new TPersonAptitude();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tPersonAptitudeList.add(data);
            }
            boolean result = tPersonAptitudeService.updateBatchById(tPersonAptitudeList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 人员资质管理 分页列表", notes = "List TPersonAptitude with page")
    @PostMapping(value = "/list")
    public BaseResponse<BaseResponseList<TPersonAptitude>> listEntity(@RequestBody TPersonAptitudeParam param) {
        BaseResponse<BaseResponseList<TPersonAptitude>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TPersonAptitude> resultPage = new Page<>(page, limit);
        QueryWrapper<TPersonAptitude> queryWrapper = this.createQuery(param);
        Page<TPersonAptitude> resultList = tPersonAptitudeService.page(resultPage, queryWrapper);
        List<TPersonAptitude> records = resultList.getRecords();
        for (TPersonAptitude record : records) {
            SysOrg regionalCompany = tOrgService.getRegionalCompany(record.getOrgId());
            if (regionalCompany != null) {
                record.setBusinessOrgName(regionalCompany.getOrgName());
            }
        }
        BaseResponseList<TPersonAptitude> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(records);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    //    @ApiOperation(value = "获取 人员资质管理 列表", notes = "List TPersonAptitude all")
//    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TPersonAptitude>> listAllEntity(TPersonAptitudeParam param) {
        BaseResponse<BaseResponseList<TPersonAptitude>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPersonAptitude> queryWrapper = this.createQuery(param);
        List<TPersonAptitude> resultList = tPersonAptitudeService.list(queryWrapper);
        BaseResponseList<TPersonAptitude> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TPersonAptitude> createQuery(TPersonAptitudeParam queryParam) {
        QueryWrapper<TPersonAptitude> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc(TPersonAptitude.CREATE_DATE);
        String rule = sysRuleService.dataRuleScope(DefaultRule.DEPT_SUB.name());
        if (StringUtils.isNotEmpty(rule)) {
            queryWrapper.apply(rule);
        }
        if (StringHelper.isNotEmpty(queryParam.getAptitudeName())) {
            String[] split = queryParam.getAptitudeName().split(",");
            queryWrapper.in(TPersonAptitude.APTITUDE_NAME, split);
        }
        if (StringHelper.isNotEmpty(queryParam.getAptitudeStatus())) {
            queryWrapper.eq(TPersonAptitude.APTITUDE_STATUS, queryParam.getAptitudeStatus());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getStartData()) && ObjectHelper.isNotEmpty(queryParam.getEndData())) {
            queryWrapper.between(TPersonAptitude.APTITUDE_VALID, queryParam.getStartData(), queryParam.getEndData());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgIds())) {
            queryWrapper.in(TPersonAptitude.ORG_ID, queryParam.getOrgIds());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TPersonAptitude.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TPersonAptitude.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TPersonAptitude.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
