package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorTools;
import com.testor.module.contractor.ledger.service.TContractorToolsService;
import com.testor.module.contractor.manage.dao.TContractorAllowToolsDao;
import com.testor.module.contractor.manage.model.domain.TContractorAllowTools;
import com.testor.module.contractor.manage.model.dto.TContractorAllowToolsParam;
import com.testor.module.contractor.manage.model.vo.TContractorAllowToolsVo;
import com.testor.module.contractor.manage.service.TContractorAllowToolsService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 准入信息-工器具台账关联Service业务层处理
 *
 * @author testor-framework
 * @date 2024-11-26 14:09:01
 */
@Service
public class TContractorAllowToolsServiceImpl extends SuperServiceImpl<TContractorAllowToolsDao, TContractorAllowTools> implements TContractorAllowToolsService {
    @Autowired(required = false)
    private TContractorAllowToolsDao tContractorAllowToolsDao;
    @Autowired
    private TContractorToolsService tContractorToolsService;

    @Override
    public List<String> getIdsByAllowId(String allowId) {
        List<TContractorAllowTools> list = this.list(new LambdaQueryWrapper<>(TContractorAllowTools.class).eq(TContractorAllowTools::getAllowId, allowId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(TContractorAllowTools::getToolsId).collect(Collectors.toList());
    }

    @Override
    public List<TContractorAllowTools> listAllEntity(TContractorAllowToolsParam param) {
        QueryWrapper<TContractorAllowTools> queryWrapper = this.createQuery(param);
        List<TContractorAllowTools> toolsList = this.list(queryWrapper);
        for (TContractorAllowTools tools : toolsList) {
            String toolsId = tools.getToolsId();
            TContractorTools byId = tContractorToolsService.getById(toolsId);
            tools.setTContractorTools(byId);
            tools.setId(toolsId);
        }
        return toolsList;
    }

    @Override
    public Page<TContractorAllowToolsVo> listEntity(TContractorAllowToolsParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TContractorAllowTools> resultPage = new Page<>(page, limit);
        QueryWrapper<TContractorAllowTools> queryWrapper = this.createQuery(param);
        Page<TContractorAllowTools> pageList = this.page(resultPage, queryWrapper);
        List<TContractorAllowTools> records = pageList.getRecords();

        List<TContractorAllowToolsVo> voList = new ArrayList<>();
        for (TContractorAllowTools tools : records) {
            String toolsId = tools.getToolsId();
            TContractorTools byId = tContractorToolsService.getById(toolsId);
            TContractorAllowToolsVo vo = new TContractorAllowToolsVo();
            if (byId != null) {
                BeanUtils.copyProperties(byId, vo);
                tools.setTContractorTools(byId);
            }
            BeanUtils.copyProperties(tools, vo);
            vo.setId(toolsId);
            voList.add(vo);
        }
        Page<TContractorAllowToolsVo> pageVo =new Page<>();
        pageVo.setRecords(voList);
        pageVo.setTotal(pageList.getTotal());
        return pageVo;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorAllowTools> createQuery(TContractorAllowToolsParam queryParam) {
        QueryWrapper<TContractorAllowTools> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getAllowId())) {
            queryWrapper.eq(TContractorAllowTools.ALLOW_ID, queryParam.getAllowId());
        }
        if (StringHelper.isNotEmpty(queryParam.getToolsId())) {
            queryWrapper.eq(TContractorAllowTools.TOOLS_ID, queryParam.getToolsId());
        }
        if (StringHelper.isNotEmpty(queryParam.getBizId())) {
            queryWrapper.eq(TContractorAllowTools.BIZ_ID, queryParam.getBizId());
        }
        if (StringHelper.isNotEmpty(queryParam.getContractorId())) {
            queryWrapper.eq(TContractorAllowTools.CONTRACTOR_ID, queryParam.getContractorId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProjId())) {
            queryWrapper.eq(TContractorAllowTools.PROJ_ID, queryParam.getProjId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorAllowTools.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorAllowTools.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TContractorAllowTools.UPDATE_DATE);
        }
        return queryWrapper;
    }

}
