package com.testor.module.duty.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 值班日志对象 t_sys_duty_log
 * 
 * @author testor-framework
 * @date 2022-06-08 14:31:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_duty_log")
@ApiModel(value = "TSysDutyLog对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysDutyLog extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键 id
 */
  @ApiModelProperty(value = "主键 id")

  @TableId("id")
  private String id;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;

  @ApiModelProperty(value = "班次", required = true)
  @TableField("classes")
  private String classes ;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例id
 */
  @ApiModelProperty(value = "流程实例id")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 值班日期
 */
  @ApiModelProperty(value = "值班日期")

  @TableField("duty_date")
  private String dutyDate;
/**
 * 值班领导
 */
  @ApiModelProperty(value = "值班领导")

  @TableField("duty_leader")
  private String dutyLeader;
/**
 * 天气情况
 */
  @ApiModelProperty(value = "天气情况")

  @TableField("weather")
  private String weather;
/**
 * 时段（工作日，节假日）
 */
  @ApiModelProperty(value = "时段（工作日，节假日）")

  @TableField("time_section")
  private String timeSection;
/**
 * 当班门岗保卫姓名
 */
  @ApiModelProperty(value = "当班门岗保卫姓名")

  @TableField("defend_name")
  private String defendName;
/**
 * 其他工作
 */
  @ApiModelProperty(value = "其他工作")

  @TableField("other_work")
  private String otherWork;
/**
 * 关联作业活动id
 */
  @ApiModelProperty(value = "关联作业活动id")

  @TableField("job_id")
  private String jobId;
/**
 * 当班其他人员
 */
  @ApiModelProperty(value = "当班其他人员")

  @TableField("other_staffs")
  private String otherStaffs;
/**
 * 突发情况
 */
  @ApiModelProperty(value = "突发情况")

  @TableField("emergency")
  private String emergency;
/**
 * 遗留问题办理情况
 */
  @ApiModelProperty(value = "遗留问题办理情况")

  @TableField("issue_apply")
  private String issueApply;
/**
 * 交接内容注意事项
 */
  @ApiModelProperty(value = "交接内容注意事项")

  @TableField("attention_matter")
  private String attentionMatter;
/**
 * 交接内容采取措施
 */
  @ApiModelProperty(value = "交接内容采取措施")

  @TableField("take_step")
  private String takeStep;
/**
 * 交接内容遗留问题
 */
  @ApiModelProperty(value = "交接内容遗留问题")

  @TableField("handover_issue")
  private String handoverIssue;
/**
 * 交班领导签字
 */
  @ApiModelProperty(value = "交班领导签字")

  @TableField("handover_sign")
  private String handoverSign;
/**
 * 单位归属
 */
  @ApiModelProperty(value = "单位归属")

  @TableField("unit_belong")
  private String unitBelong;
/**
 * 接班领导签字
 */
  @ApiModelProperty(value = "接班领导签字")

  @TableField("succession_sign")
  private String successionSign;
/**
 * 企业id
 */
  @ApiModelProperty(value = "企业id")

  @TableField("company_id")
  private String companyId;

  /**
   * 单位名称
   */
  @ApiModelProperty(value = "单位名称")
  @TableField("company_name")
  private String companyName;

  /**
   * 部门名称
   */
  @ApiModelProperty(value = "部门名称")
  @TableField("dept_name")
  private String deptName;

  /**
   * 提交人
   */
  @ApiModelProperty(value = "提交人")
  @TableField("submitter")
  private String submitter;

  /**
   * 接收对象类型
   */
  @ApiModelProperty(value = "接收对象类型")
  @TableField("receiver_type")
  private String receiverType;

  /**
   * 接收对象
   */
  @ApiModelProperty(value = "接收对象")
  @TableField("receiver_obj")
  private String receiverObj;

  /**
   * 上一个班次遗留问题
   */
  @ApiModelProperty(value = "上一个班次遗留问题")
  @TableField("pre_handover_issue")
  private String preHandoverIssue;

  /**
   * 无危险作业原因
   */
  @ApiModelProperty(value = "无危险作业原因")

  @TableField("cause")
  private String cause;

  @ApiModelProperty(value = "交班审核意见")
  @TableField("handover_reject_opinion")
  private String handoverRejectOpinion ;

  @ApiModelProperty(value = "接班审核意见")
  @TableField("succession_reject_opinion")
  private String successionRejectOpinion ;

  @ApiModelProperty(value = "是否特殊时段")
  @TableField("is_special_time")
  private String isSpecialTime;

  public static final String ID ="id";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String DUTY_DATE ="duty_date";
  public static final String DUTY_LEADER ="duty_leader";
  public static final String WEATHER ="weather";
  public static final String TIME_SECTION ="time_section";
  public static final String DEFEND_NAME ="defend_name";
  public static final String OTHER_WORK ="other_work";
  public static final String JOB_ID ="job_id";
  public static final String OTHER_STAFFS ="other_staffs";
  public static final String EMERGENCY ="emergency";
  public static final String ISSUE_APPLY ="issue_apply";
  public static final String ATTENTION_MATTER ="attention_matter";
  public static final String TAKE_STEP ="take_step";
  public static final String HANDOVER_ISSUE ="handover_issue";
  public static final String HANDOVER_SIGN ="handover_sign";
  public static final String UNIT_BELONG ="unit_belong";
  public static final String SUCCESSION_SIGN ="succession_sign";
  public static final String COMPANY_ID ="company_id";
  public static final String COMPANY_NAME ="company_name";
  public static final String DEPT_NAME  ="dept_name";
  public static final String SUBMITTER  ="submitter";
  public static final String RECEIVER_TYPE  ="receiver_type";
  public static final String RECEIVER_OBJ  ="receiver_obj";
  public static final String PRE_HANDOVER_ISSUE  ="pre_handover_issue";
  public static final String CAUSE  ="cause";
  public static final String HANDOVER_REJECT_OPINION  ="handover_reject_opinion";
  public static final String SUCCESSION_REJECT_OPINION  ="succession_reject_opinion";
  public static final String IS_SPECIAL_TIME  ="is_special_time";

}
