package com.testor.module.emergency.service;



import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.domain.TEmergencyRehearsal;
import com.testor.module.emergency.model.dto.EvaluateDTO;
import com.testor.module.emergency.model.dto.TEmergencyRehearsalDTO;
import com.testor.module.emergency.model.dto.TEmergencyRehearsalParam;
import com.testor.module.emergency.model.vo.EvaluateVO;
import com.testor.module.emergency.model.vo.TEmergencyRehearsalVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

/**
 * 应急预案演练Service接口
 * 
 * @author testor-framework
 * @date 2022-12-02 15:50:38
 */
public interface TEmergencyRehearsalService extends SuperService<TEmergencyRehearsal> {

    boolean addAndUpdate(TEmergencyRehearsalDTO addRequest);

    /**
     * 获取分页列表
     *
     * @param resultPage 结果页面
     * @param param      参数
     * @return {@link Page}<{@link TEmergencyRehearsal}>
     */
    Page<TEmergencyRehearsalVO> listPage(Page<TEmergencyRehearsalVO> resultPage, TEmergencyRehearsalParam param);

    /**
     * 添加评价
     *
     * @param evaluateDTO 评估dto
     * @return boolean
     */
    boolean addEvaluate(EvaluateDTO evaluateDTO);

    /**
     * 获取评价
     * @param id
     * @return
     */
    EvaluateVO getEvaluate(String id);
}
