package com.testor.module.environment.controller;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.rule.service.SysRuleService;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.constant.DefaultRule;
import com.testor.common.util.BeanConverUtil;
import com.testor.config.CustomCellWriteHeightConfig;
import com.testor.config.CustomCellWriteWeightConfig;
import com.testor.module.accident.model.resp.ReportUnitResp;
import com.testor.module.environment.model.domain.TEnvironmentMonthly;
import com.testor.module.environment.model.dto.*;
import com.testor.module.environment.service.TBasicEnvironmentManageService;
import com.testor.module.environment.service.TEnvironmentMonthlyService;
import com.testor.module.sys.service.NewSysDictDataService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 节能环保月报Controller
 *
 * @author testor-framework
 * @date 2022-09-22 17:21:15
 */
@RestController
@RequestMapping("/monthly")
@Api(value = "TEnvironmentMonthly", tags = "节能环保月报")
@Slf4j
public class TEnvironmentMonthlyController extends SuperController {
    @Autowired
    private TEnvironmentMonthlyService tEnvironmentMonthlyService;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private SysRuleService sysRuleService;
    @Autowired
    private TBasicEnvironmentManageService tBasicEnvironmentManageService;
    @Autowired
    private NewSysDictDataService sysDictDataService;

    @ApiOperation(value = "获取已经上报过的年月 ", notes = "")
    @GetMapping(value = "/getPastMonth")
    public BaseResponse<List<TEnvironmentMonthly>> getPastMonth() {
        return tEnvironmentMonthlyService.getPastMonth();
    }

    @ApiOperation(value = "获取首页节能环保月报 ", notes = "Get TEnvironmentMonthly By Id")
    @GetMapping(value = "/getMonthHome")
    public BaseResponse<List<HomeEnvironment>> getMonthHome(String orgId) {
        return tEnvironmentMonthlyService.getMonthHome(orgId);
    }

    @ApiOperation(value = "获取月报列表统计数据 ", notes = "")
    @GetMapping(value = "/getListCount")
    public BaseResponse<TEnvironmentMonthly> getListCount(TEnvironmentMonthlyParam queryParam) {
        BaseResponse<TEnvironmentMonthly> response = new BaseResponse<>();
        TEnvironmentMonthly environmentMonthly = tEnvironmentMonthlyService.getListCount(queryParam);
        response.setData(environmentMonthly);
        return response;
    }

    @ApiOperation(value = "变更单位", notes = "")
    @GetMapping(value = "/updateUnit")
    public BaseResponse updateUnit() {
        BaseResponse response = new BaseResponse<>();
        response.setData(tEnvironmentMonthlyService.updateUnit());
        return response;
    }

    @SneakyThrows
    @ApiOperation(value = "导出月报列表数据 ", notes = "")
    @GetMapping(value = "/exportList")
    public BaseResponse<String> exportList(TEnvironmentMonthlyParam param, HttpServletResponse response) {
        BaseResponse<String> result = new BaseResponse<>();
        param.setPage("-1");
        param.setLimit("-1");
        List<TEnvironmentMonthly> list = listEntity(param).getData().getData();
        for (TEnvironmentMonthly tEnvironmentMonthly : list) {
            String orgId = tEnvironmentMonthly.getOrgId();
            ReportUnitResp reportUnitResp = tBasicEnvironmentManageService.lookOrg(orgId);
            String subSectorPath = reportUnitResp.getSubSectorPath();
            String[] pathParts = subSectorPath.split("/");
            if (pathParts.length >= 3) {
                tEnvironmentMonthly.setRegionalOrgName(pathParts[0]);  // 第一层: 大区
                tEnvironmentMonthly.setBusinessDepartmentName(pathParts[1]);  // 第二层: 经营部
                tEnvironmentMonthly.setOrgName(pathParts[2]);  // 第三层: 基层企业
            } else if (pathParts.length == 2) {
                tEnvironmentMonthly.setRegionalOrgName(pathParts[0]);  // 第一层: 大区
                tEnvironmentMonthly.setBusinessDepartmentName(pathParts[1]);  // 第二层: 经营部
            } else if (pathParts.length == 1) {
                tEnvironmentMonthly.setRegionalOrgName(pathParts[0]);  // 第一层: 大区
            }
        }
        List<TEnvironmentMonthlyPo> tEnvironmentMonthlyPos = BeanConverUtil.converList(list, TEnvironmentMonthlyPo.class);
        String fileName = URLEncoder.encode("节能环保月报", "utf-8");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        EasyExcel.write(response.getOutputStream(), TEnvironmentMonthlyPo.class).registerWriteHandler(new CustomCellWriteWeightConfig())
                .registerWriteHandler(new CustomCellWriteHeightConfig()).sheet("节能环保月报").doWrite(tEnvironmentMonthlyPos);
        result.setMsg("导出成功");
        return result;
    }


    /* Generated Method*/
    @ApiOperation(value = "新增 节能环保月报", notes = "Add TEnvironmentMonthly")
    @PostMapping(value = "/add")
    public BaseResponse<TEnvironmentMonthly> addEntity(@RequestBody TEnvironmentMonthly addRequest) throws Exception {
        BaseResponse<TEnvironmentMonthly> baseResponse = new BaseResponse<>();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        String orgName = sysOrgService.getById(orgId).getOrgName();
        // 获取当前年月
        Calendar calendar = Calendar.getInstance();
        // 获取当前年
        String year = Integer.toString(calendar.get(Calendar.YEAR));
        // 获取当前月
        String currentMonth = Integer.toString((calendar.get(Calendar.MONTH) + 1));
        // 获取当前日
        String currentDay = Integer.toString((calendar.get(Calendar.DATE)));
        // 当前日期
        String yearMonth = year + "-" + currentMonth + "-" + currentDay;
        // 获取传入的上报日期
        String month = addRequest.getMonth();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = sdf.parse(month);

        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
        // 上传月
        String format = sd.format(parse);
        // 设置月份标记
//        String sign = setMonthSign(format);
        // 当前月
        String currentYearMonth = year + "-" + currentMonth;

        if (format.compareTo(currentYearMonth) > 0) {
            throw new BusinessException("上报日期未到");
        }
        List<TEnvironmentMonthly> data1 = tEnvironmentMonthlyService.getPastMonth().getData();
        List<TEnvironmentMonthly> collect = data1.stream().filter(item -> {
            return item.getMonth().equals(format);
        }).collect(Collectors.toList());
        if (collect.size() > 0 && StringHelper.isBlank(addRequest.getId())) {
            throw new BusinessException("该月已经上报，请勿重复上报");
        }
        // 上传月的次月6号
        // String NM = TimeTools(parse);
        //Date parse1 = sdf.parse(NM);
        //获取当前月的时间并
        //String s = DateUtil.convertDateToYMDStr(new Date());
        //Date parse2 = sdf.parse(s);
        //int i = daysBetween(parse, parse2);
        // 当前月小于次月 已上报  否则逾期上报
        if (checkTime(month)) {
//        if (yearMonth.compareTo(NM)>0) {
            addRequest.setAppearStatus("1");
        } else {
            addRequest.setAppearStatus("2");
        }

/*        TEnvironmentMonthly one = tEnvironmentMonthlyService.getOne(new QueryWrapper<TEnvironmentMonthly>().eq(TEnvironmentMonthly.ORG_ID, orgId)
                .like(TEnvironmentMonthly.MONTH, addRequest.getMonth())
        );*/

        if (ObjectHelper.isNotEmpty(addRequest)) {
            String id = addRequest.getId();
            if (StringHelper.isEmpty(id)) {
                id = IdHelper.getId32bit();
            }
            TEnvironmentMonthly data = BeanHelper.beanToBean(addRequest, TEnvironmentMonthly.class);
            if (StringHelper.isEmpty(addRequest.getId())) {
                data.setOrgId(orgId);
                data.setOrgName(orgName);
            }
            data.setId(id);
            boolean result = tEnvironmentMonthlyService.saveOrUpdate(data);
            if (result) {
                TEnvironmentMonthly newEntity = new TEnvironmentMonthly();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    /**
     * 判断当前日期是否在变量month的下个月8号12点之前
     *
     * @param month
     * @return
     */
    private Boolean checkTime(String month) {
        // 获取当前日期时间
        LocalDateTime now = LocalDateTime.now();
        // 解析用户输入的日期
        LocalDateTime inputDateTime = LocalDateTime.parse(month + "T00:00:00");
        // 将日期增加一个月，并设置为8号12点
        LocalDateTime targetDateTime = inputDateTime.plusMonths(1).withDayOfMonth(8).withHour(12);
        // 转换为当前时区的ZonedDateTime，因为在不同时区下可能存在偏移
        ZonedDateTime zonedNow = now.atZone(ZoneId.systemDefault());
        ZonedDateTime zonedTargetDateTime = targetDateTime.atZone(ZoneId.systemDefault());
        // 比较当前日期时间是否在目标日期时间之前
        boolean isBeforeTarget = zonedNow.isBefore(zonedTargetDateTime);
        return isBeforeTarget;
    }

    /**
     * 设置月份标记
     *
     * @param monthly
     * @return
     */
    private MonthUpDto setMonthSign(String dateTime, MonthUpDto monthUpDto, TEnvironmentMonthly monthly) {
        String MONTH = "";
        if (StringHelper.isNotEmpty(dateTime)) {
            MONTH = dateTime.split("-")[1];
        }
//        String appearStatus = monthly.getAppearStatus();
//        if (StringHelper.isEmpty(appearStatus)) {
//            monthly.setAppearStatus("3");
//        }

        switch (MONTH) {

            case "01":
                monthUpDto.setA(monthly.getAppearStatus());
                break;
            case "02":
                monthUpDto.setB(monthly.getAppearStatus());
                break;
            case "03":
                monthUpDto.setC(monthly.getAppearStatus());
                break;
            case "04":
                monthUpDto.setD(monthly.getAppearStatus());
                break;
            case "05":
                monthUpDto.setE(monthly.getAppearStatus());
                break;
            case "06":
                monthUpDto.setF(monthly.getAppearStatus());
                break;
            case "07":
                monthUpDto.setG(monthly.getAppearStatus());
                break;
            case "08":
                monthUpDto.setH(monthly.getAppearStatus());
                break;
            case "09":
                monthUpDto.setI(monthly.getAppearStatus());
                break;
            case "10":
                monthUpDto.setJ(monthly.getAppearStatus());
                break;
            case "11":
                monthUpDto.setK(monthly.getAppearStatus());
                break;
            case "12":
                monthUpDto.setL(monthly.getAppearStatus());
                break;
        }

        return monthUpDto;
    }

    /**
     * 计算两个日期之间相差的天数
     *
     * @param startDate 较小的时间
     * @param endDate   较大的时间
     * @return 相差天数
     */
    public static int daysBetween(Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(endDate);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / (1000 * 3600 * 24);
        //返回相差天数
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 获取次月某一天
     *
     * @param date
     * @return
     * @throws Exception
     */
    private String TimeTools(Date date) throws Exception {
        Calendar calendar = Calendar.getInstance();//日历对象
        calendar.setTime(date);
        int year = calendar.get(Calendar.YEAR); //获取年
        int month = calendar.get(Calendar.MONTH) + 2; //获取月
        int day = 6;//获取日
        if (month == 12) {
            month = 1;
            year = year + 1;
        }
        String newDate = year + "-" + month + "-" + day;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = sdf.parse(newDate);
        String format = sdf.format(parse);
        return format;
    }

    @ApiOperation(value = "获取 节能环保月报 ", notes = "Get TEnvironmentMonthly By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TEnvironmentMonthly> getById(String orgId) {
        BaseResponse<TEnvironmentMonthly> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(orgId)) {
            TEnvironmentMonthly data = tEnvironmentMonthlyService.getTEnvironmentMonthlyById(orgId);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "月报上报统计", notes = "")
    @PostMapping(value = "/monthUpCount")
    public BaseResponse<BaseResponseList<MonthUpDto>> monthUpCount(@RequestBody TEnvironmentMonthlyParam param) {
        BaseResponse<BaseResponseList<MonthUpDto>> baseResponse = new BaseResponse<>();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        if (StringHelper.isNotEmpty(param.getMonth())) {
            String YEAR = param.getMonth().split("-")[0];
            param.setMonth(YEAR);
        }
        if (StringHelper.isNotEmpty(param.getOrgId())) {
            String[] split = param.getOrgId().split(",");
            List<String> list = Arrays.asList(split);
            param.setCompanyIds(list);
        }
        IPage<TEnvironmentMonthly> resultList = tEnvironmentMonthlyService.getListMonth(param, orgId);

        // 获取月报上报
        List<MonthUpDto> records = getMonthUp(resultList.getRecords());
        BaseResponseList<MonthUpDto> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(records);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /**
     * 获取月报上报
     *
     * @param records
     * @return
     */
    private List<MonthUpDto> getMonthUp(List<TEnvironmentMonthly> records) {
        Map<String, List<TEnvironmentMonthly>> collect = records.stream().collect(Collectors.groupingBy(item -> item.getOrgName()));
        List<MonthUpDto> monthlies = new ArrayList<>();
        for (String s : collect.keySet()) {
            List<TEnvironmentMonthly> tEnvironmentMonthlies = collect.get(s);
            MonthUpDto monthUpDto = new MonthUpDto();
            monthUpDto.setOrgName(s);
            for (TEnvironmentMonthly tEnvironmentMonthly : tEnvironmentMonthlies) {
                setMonthSign(tEnvironmentMonthly.getMonth(), monthUpDto, tEnvironmentMonthly);
            }
            monthlies.add(monthUpDto);
        }
        return monthlies;
    }

    @ApiOperation(value = "获取 节能环保月报 分页列表", notes = "List TEnvironmentMonthly with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TEnvironmentMonthly>> listEntity(TEnvironmentMonthlyParam param) {
        BaseResponse<BaseResponseList<TEnvironmentMonthly>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TEnvironmentMonthly> resultPage = new Page<>(page, limit);
        QueryWrapper<TEnvironmentMonthly> queryWrapper = this.createQuery(param);

        Page<TEnvironmentMonthly> resultList = tEnvironmentMonthlyService.getPage(resultPage, queryWrapper);
        BaseResponseList<TEnvironmentMonthly> baseResponseList = new BaseResponseList<>();
        //审核状态转换
        List<TEnvironmentMonthly> records = checkMonth(resultList.getRecords());
        baseResponseList.setData(records);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    private List<TEnvironmentMonthly> checkMonth(List<TEnvironmentMonthly> records) {
        records.stream().forEach(item -> {
            String month = item.getMonth();
            String year = month.substring(0, month.lastIndexOf("-"));
            item.setMonth(year);
            if ("5".equals(item.getProcessStatus())) {
                item.setProcessStatus("已通过");
            }else {
                item.setProcessStatus("审核中");
            }
        });
        return records;
    }

    //为什么不直接删掉呢？代码量=工作量？
    //    @ApiOperation(value = "修改 节能环保月报 ", notes = "Update TEnvironmentMonthly By Id")
//    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TEnvironmentMonthly updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            TEnvironmentMonthly data = BeanHelper.beanToBean(updateRequest, TEnvironmentMonthly.class);
            boolean result = tEnvironmentMonthlyService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    //    @ApiOperation(value = "删除 节能环保月报 ", notes = "delete TEnvironmentMonthly By Id")
//    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TEnvironmentMonthlyDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            TEnvironmentMonthly data = new TEnvironmentMonthly();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tEnvironmentMonthlyService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    //    @ApiOperation(value = "批量删除节能环保月报", notes = "delete TEnvironmentMonthly by batch Id")
//    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TEnvironmentMonthlyDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TEnvironmentMonthly> tEnvironmentMonthlyList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TEnvironmentMonthly data = new TEnvironmentMonthly();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tEnvironmentMonthlyList.add(data);
            }
            boolean result = tEnvironmentMonthlyService.updateBatchById(tEnvironmentMonthlyList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }


    //    @ApiOperation(value = "获取 节能环保月报 列表", notes = "List TEnvironmentMonthly all")
//    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TEnvironmentMonthly>> listAllEntity(TEnvironmentMonthlyParam param) {
        BaseResponse<BaseResponseList<TEnvironmentMonthly>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TEnvironmentMonthly> queryWrapper = this.createQuery(param);
        List<TEnvironmentMonthly> resultList = tEnvironmentMonthlyService.list(queryWrapper);
        BaseResponseList<TEnvironmentMonthly> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TEnvironmentMonthly> createQuery(TEnvironmentMonthlyParam queryParam) {
        QueryWrapper<TEnvironmentMonthly> queryWrapper = new QueryWrapper<>();
        String rule = sysRuleService.dataRuleScope(DefaultRule.DEPT_SUB.name());
        if (StringUtils.isNotEmpty(rule)) {
            queryWrapper.apply(rule);
        }

        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            String[] split = queryParam.getOrgId().split(",");
            queryWrapper.in(TEnvironmentMonthly.ORG_ID, split);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgName())) {
            queryWrapper.like(TEnvironmentMonthly.ORG_NAME, queryParam.getOrgName());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getStartDate()) && ObjectHelper.isNotEmpty(queryParam.getEndDate())) {
            queryWrapper.between(TEnvironmentMonthly.MONTH, queryParam.getStartDate(), queryParam.getEndDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyCoal())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_COAL, queryParam.getEnergyCoal());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyPower())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_POWER, queryParam.getEnergyPower());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyGasoline())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_GASOLINE, queryParam.getEnergyGasoline());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyDerv())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_DERV, queryParam.getEnergyDerv());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyFuel())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_FUEL, queryParam.getEnergyFuel());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyNatural())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_NATURAL, queryParam.getEnergyNatural());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyHeating())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_HEATING, queryParam.getEnergyHeating());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyOther())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_OTHER, queryParam.getEnergyOther());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergySynthesize())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_SYNTHESIZE, queryParam.getEnergySynthesize());
        }
        if (StringHelper.isNotEmpty(queryParam.getWaterNew())) {
            queryWrapper.eq(TEnvironmentMonthly.WATER_NEW, queryParam.getWaterNew());
        }
        if (StringHelper.isNotEmpty(queryParam.getWaterRepetition())) {
            queryWrapper.eq(TEnvironmentMonthly.WATER_REPETITION, queryParam.getWaterRepetition());
        }
        if (StringHelper.isNotEmpty(queryParam.getWaterRate())) {
            queryWrapper.eq(TEnvironmentMonthly.WATER_RATE, queryParam.getWaterRate());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantODischarge())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_O_DISCHARGE, queryParam.getWPollutantODischarge());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantOCod())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_O_COD, queryParam.getWPollutantOCod());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantONh3n())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_O_NH3N, queryParam.getWPollutantONh3n());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantIDischarge())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_I_DISCHARGE, queryParam.getWPollutantIDischarge());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantICod())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_I_COD, queryParam.getWPollutantICod());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantINh3n())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_I_NH3N, queryParam.getWPollutantINh3n());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantThirdDischarge())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_THIRD_DISCHARGE, queryParam.getWPollutantThirdDischarge());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantThirdCod())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_THIRD_COD, queryParam.getWPollutantThirdCod());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantThirdNh3n())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_THIRD_NH3N, queryParam.getWPollutantThirdNh3n());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantDischargeSum())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_DISCHARGE_SUM, queryParam.getWPollutantDischargeSum());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantCodSum())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_COD_SUM, queryParam.getWPollutantCodSum());
        }
        if (StringHelper.isNotEmpty(queryParam.getWPollutantNh3nSum())) {
            queryWrapper.eq(TEnvironmentMonthly.W_POLLUTANT_NH3N_SUM, queryParam.getWPollutantNh3nSum());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantStack())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_STACK, queryParam.getAtmospherePollutantStack());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantSo2())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_SO2, queryParam.getAtmospherePollutantSo2());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantNh3n())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_NH3N, queryParam.getAtmospherePollutantNh3n());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantNh3nOrganic())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_NH3N_ORGANIC, queryParam.getAtmospherePollutantNh3nOrganic());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantNh3nCo2())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_NH3N_CO2, queryParam.getAtmospherePollutantNh3nCo2());
        }
        if (StringHelper.isNotEmpty(queryParam.getAtmospherePollutantNh3nCount())) {
            queryWrapper.eq(TEnvironmentMonthly.ATMOSPHERE_POLLUTANT_NH3N_COUNT, queryParam.getAtmospherePollutantNh3nCount());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidSlag())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_SLAG, queryParam.getSolidSlag());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidSieve())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_SIEVE, queryParam.getSolidSieve());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidOther())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_OTHER, queryParam.getSolidOther());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidProduce())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_PRODUCE, queryParam.getSolidProduce());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidUse())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_USE, queryParam.getSolidUse());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidMunicipal())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_MUNICIPAL, queryParam.getSolidMunicipal());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidDispose())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_DISPOSE, queryParam.getSolidDispose());
        }
        if (StringHelper.isNotEmpty(queryParam.getSolidRatio())) {
            queryWrapper.eq(TEnvironmentMonthly.SOLID_RATIO, queryParam.getSolidRatio());
        }
        if (StringHelper.isNotEmpty(queryParam.getRiskProduce())) {
            queryWrapper.eq(TEnvironmentMonthly.RISK_PRODUCE, queryParam.getRiskProduce());
        }
        if (StringHelper.isNotEmpty(queryParam.getRiskDispose())) {
            queryWrapper.eq(TEnvironmentMonthly.RISK_DISPOSE, queryParam.getRiskDispose());
        }
        if (StringHelper.isNotEmpty(queryParam.getRiskRatio())) {
            queryWrapper.eq(TEnvironmentMonthly.RISK_RATIO, queryParam.getRiskRatio());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnergyPut())) {
            queryWrapper.eq(TEnvironmentMonthly.ENERGY_PUT, queryParam.getEnergyPut());
        }
        if (StringHelper.isNotEmpty(queryParam.getRecyclePut())) {
            queryWrapper.eq(TEnvironmentMonthly.RECYCLE_PUT, queryParam.getRecyclePut());
        }
        if (StringHelper.isNotEmpty(queryParam.getAppearStatus())) {
            queryWrapper.eq(TEnvironmentMonthly.APPEAR_STATUS, queryParam.getAppearStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            if (queryParam.getProcessStatus().equals("5")){
                queryWrapper.eq(TEnvironmentMonthly.PROCESS_STATUS, queryParam.getProcessStatus());
            }else {
                queryWrapper.ne(TEnvironmentMonthly.PROCESS_STATUS, "5");
            }

        }
        if (StringHelper.isNotEmpty(queryParam.getRejectOpinion())) {
            queryWrapper.eq(TEnvironmentMonthly.REJECT_OPINION, queryParam.getRejectOpinion());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TEnvironmentMonthly.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TEnvironmentMonthly.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TEnvironmentMonthly.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public static void main(String[] args) {
        String YEAR = "2024-01".split("-")[0];
        System.out.println(YEAR);
    }
}
