package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 巡检任务延期申请对象 t_safe_hazard_check_delay
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_delay")
@ApiModel(value = "TSafeHazardCheckDelay对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckDelay extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 任务id
 */
  @ApiModelProperty(value = "任务id(新增、编辑必填)")

  @TableField("task_id")
  private String taskId;
/**
 * 审批人id
 */
  @ApiModelProperty(value = "审批人id")
  @TableField("approval_user_id")
  private String approvalUserId;
/**
 * 原排查时间(任务结束时间)
 */
  @ApiModelProperty(value = "原排查时间(任务结束时间)")
  @TableField("initial_check_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date initialCheckDate;
/**
 * 延期原因
 */
  @ApiModelProperty(value = "延期原因(新增、编辑必填)")
  @TableField("reason")
  private String reason;
/**
 * 审批意见
 */
  @ApiModelProperty(value = "审批意见(审核时选填)")
  @TableField("approval_opinion")
  private String approvalOpinion;
/**
 * 延期排查时间(任务结束时间)
 */
  @ApiModelProperty(value = "延期排查时间(任务结束时间)(新增、编辑必填)")
  @TableField("delay_check_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date delayCheckDate;
/**
 * 申请时间
 */
  @ApiModelProperty(value = "申请时间")
  @TableField("apply_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date applyDate;
/**
 * 审批时间
 */
  @ApiModelProperty(value = "审批时间")
  @TableField("approval_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date approvalDate;

  @ApiModelProperty(value = "审批结果（审核时必填）(0-未通过；1-通过; 2-进行中)")
  @TableField("approval_status")
  private Integer approvalStatus;

  @ApiModelProperty(value = "流程实例id（流程创建时必填）")
  @TableField("process_id")
  private String processId;

  @ApiModelProperty(value = "-1、不存在接收对象，0：所有人，1-代表接收人、2代表组织结构")
  @TableField("receiver_type")
  private Integer receiverType;

  @ApiModelProperty(value = "接收对象：可为人，组织机构，根据receiver_type确定")
  @TableField("receiver_obj")
  private Integer receiverObj;

  public static final String ID ="id";
  public static final String TASK_ID ="task_id";
  public static final String APPROVAL_USER_ID ="approval_user_id";
  public static final String INITIAL_CHECK_DATE ="initial_check_date";
  public static final String REASON ="reason";
  public static final String APPROVAL_OPINION ="approval_opinion";
  public static final String DELAY_CHECK_DATE ="delay_check_date";
  public static final String APPLY_DATE ="apply_date";
  public static final String APPROVAL_DATE ="approval_date";
  public static final String APPROVAL_STATUS ="approval_status";

}
