package com.testor.module.train.course.service;


import com.testor.module.train.course.model.domain.TTrainCourse;
import com.testor.module.train.course.model.dto.TTrainCourseDelParam;
import com.testor.module.train.course.model.dto.TTrainCourseParam;
import com.testor.module.train.database.model.domain.TTrainDatabase;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 课程管理——安全培训教育Service接口
 *
 * @author testor-framework
 * @date 2022-07-25 18:06:04
 */
public interface TTrainCourseService extends SuperService<TTrainCourse> {

    BaseResponse<TTrainCourse> addEntity(TTrainCourseParam addRequest)throws Exception;

    BaseResponse<TTrainCourseParam> getByIds(String id);

    BaseResponse<TTrainCourseParam> getBySection(String id, String taskId);

    BaseResponse<BizGeneralResponse> updateEntity(TTrainCourse updateRequest);

    BaseResponse<BizGeneralResponse> deleteEntity(TTrainCourseDelParam deleteRequest);

    BaseResponse<List<TTrainDatabase>> selectData(String dictKey);

    BaseResponse<List<TTrainDatabase>> fuzzySearch(String dataName);
    // 培训计划获取课程详情
    List<TTrainCourse> getCourse(String courseId);

    List<TTrainCourse> getDetailCourse(String courseId);

    void joinLearn(TTrainCourse addRequest) throws Exception;
}
