package com.testor.module.train.myManagement.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 我的课程学习统计—安全培训教育对象 t_train_course_learn_statistics
 * 
 * @author testor-framework
 * @date 2022-08-10 14:04:09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_course_learn_statistics")
@ApiModel(value = "TTrainCourseLearnStatistics对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainCourseLearnStatistics extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 任务id
 */
  @ApiModelProperty(value = "任务id")

  @TableField("task_id")
  private String taskId;
/**
 * 课程id
 */
  @ApiModelProperty(value = "课程id")

  @TableField("course_id")
  private String courseId;
/**
 * 课程进度
 */
  @ApiModelProperty(value = "课程进度")

  @TableField("course_plan")
  private String coursePlan;

  @TableField(select = false)
  private Integer coursePlanI;
/**
 * 章节id
 */
  @ApiModelProperty(value = "章节id")

  @TableField("section_id")
  private String sectionId;
/**
 * 章节进度
 */
  @ApiModelProperty(value = "章节进度")

  @TableField("section_plan")
  private String sectionPlan;
/**
 * 小节id
 */
  @ApiModelProperty(value = "小节id")

  @TableField("small_node_id")
  private String smallNodeId;
/**
 * 小节进度
 */
  @ApiModelProperty(value = "小节进度")

  @TableField("small_plan")
  private String smallPlan;
/**
 * 人员id
 */
  @ApiModelProperty(value = "人员id")

  @TableField("person_id")
  private String personId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;

  public static final String ID ="id";
  public static final String TASK_ID ="task_id";
  public static final String COURSE_ID ="course_id";
  public static final String COURSE_PLAN ="course_plan";
  public static final String SECTION_ID ="section_id";
  public static final String SECTION_PLAN ="section_plan";
  public static final String SMALL_NODE_ID ="small_node_id";
  public static final String SMALL_PLAN ="small_plan";
  public static final String PERSON_ID ="person_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PARENT_ID ="parent_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String TENANT_ID ="tenant_id";


}
