package com.testor.module.video.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.video.dao.VideoDeviceNumberDao;
import com.testor.module.video.model.domain.ThreeVideoInfo;
import com.testor.module.video.model.domain.VideoDeviceNumber;
import com.testor.module.video.service.VideoDeviceNumberService;
import com.testor.module.video.util.RequestVideoInfoUtil;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 视频监控设备信息和粮库对应Service业务层处理
 *
 * @author testor-framework
 * @date 2022-12-14 14:14:44
 */
@Service
public class VideoDeviceNumberServiceImpl implements VideoDeviceNumberService {
    @Autowired(required = false)
    private VideoDeviceNumberDao videoDeviceNumberDao;

	@Autowired
	private RequestVideoInfoUtil requestUtil;

	@Autowired
	private SysOrgService sysOrgService;

	@Override
	public void batchInsert() {
		//先调用登录接口
		ResponseEntity<Map> post = requestUtil.post(Map.class);
		Map body = post.getBody();
		Integer code = (Integer) body.get("code");
		//先从数据库中将粮库列表全部查询出来
		List<SysOrg> orgList=this.getOrgInfo();
		if(code == 0){
			Map data = (Map) body.get("data");
			List<Map> cameraInfoList = (List<Map>) data.get("cameraInfoList");
			//遍历数组，将数组中的数据处理
			List<ThreeVideoInfo> threeVideoInfos = JSONArray.parseArray(JSON.toJSONString(cameraInfoList), ThreeVideoInfo.class);
			List<VideoDeviceNumber> list = new ArrayList<>();
			for (ThreeVideoInfo threeVideoInfo : threeVideoInfos) {
				for (SysOrg sysOrg : orgList) {
					if (threeVideoInfo != null && sysOrg != null){
						if (threeVideoInfo.getOfficeName() != null){
							if (threeVideoInfo.getOfficeName().equals(sysOrg.getOrgName())){
								VideoDeviceNumber videoDeviceNumber = new VideoDeviceNumber();
								videoDeviceNumber.setOrgName(threeVideoInfo.getOfficeName());
								videoDeviceNumber.setOrgShortName(threeVideoInfo.getOfficeShortName());
								videoDeviceNumber.setCameraType(threeVideoInfo.getCameraType());
								videoDeviceNumber.setOrgId(sysOrg.getOrgId());
								videoDeviceNumber.setDeviceId(threeVideoInfo.getDeviceId());
								videoDeviceNumber.setCameraCode(threeVideoInfo.getCameraCode());
								videoDeviceNumber.setCameraName(threeVideoInfo.getCameraName());
								videoDeviceNumber.setCameraPosition(threeVideoInfo.getCameraPosition());
								videoDeviceNumber.setStatus(threeVideoInfo.getStatus());
								list.add(videoDeviceNumber);
							}
						}
					}
				}
			}
			//再插入前先清理所有数据
			videoDeviceNumberDao.clear();
			videoDeviceNumberDao.insertBatch(list);
		}
		System.out.println(post);
	}

	@Override
	public List<String> getDeviceIdByOrgId(String childrenOrgId) {
		return videoDeviceNumberDao.getDeviceIdByOrgId(childrenOrgId);
	}

	private List<SysOrg> getOrgInfo() {
		QueryWrapper<SysOrg> queryWrapper = new QueryWrapper();
		queryWrapper.eq("is_dept", 0);
		queryWrapper.eq("tree_level",3);
		queryWrapper.eq("status","0");
		return sysOrgService.list(queryWrapper);
	}

}
