/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument;

import com.tongweb.commons.monitor.core.instrument.AbstractMeter;
import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.DistributionSummary;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.Histogram;
import com.tongweb.commons.monitor.core.instrument.distribution.HistogramSnapshot;
import com.tongweb.commons.monitor.core.instrument.distribution.NoopHistogram;
import com.tongweb.commons.monitor.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.tongweb.commons.monitor.core.instrument.distribution.TimeWindowPercentileHistogram;
import com.tongweb.commons.monitor.core.instrument.util.MeterEquivalence;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    protected final Histogram histogram;
    private final double scale;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        super(id);
        this.scale = scale;
        this.histogram = distributionStatisticConfig.isPublishingPercentiles() ? new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : (distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : NoopHistogram.INSTANCE);
    }

    @Override
    public final void record(double amount) {
        if (amount >= 0.0) {
            double scaledAmount = this.scale * amount;
            this.histogram.recordDouble(scaledAmount);
            this.recordNonNegative(scaledAmount);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max());
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

