package com.testor.ddd.safetyControl.infrastructure.repository.riskMap.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskMap.entity.TSafeRiskMapElementRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskMap.dao.TSafeRiskMapElementDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskMap.entity.TSafeRiskMapElementDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapElementVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskMapElementServiceImpl extends SuperServiceImpl<TSafeRiskMapElementDao, TSafeRiskMapElementDO>
        implements TSafeRiskMapElementRepo

{
    @Autowired(required = false)
    private TSafeRiskMapElementDao tSafeRiskMapElementDao;

    public boolean deleteByRiskBizId(String riskBizId){
        UpdateWrapper<TSafeRiskMapElementDO>  updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskMapElementDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskMapElementDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskMapElementDO::getMapId, riskBizId);
        return update(updateWrapper);
    }

    public boolean saveBatch(List<TSafeRiskMapElementDTO> riskMapElementDTOList){
        List<TSafeRiskMapElementDO> riskMapElementDOList = BeanHelper.listToList(riskMapElementDTOList, TSafeRiskMapElementDO.class);
        return saveBatch(riskMapElementDOList);
    }

    public BaseResponseList<TSafeRiskMapElementVO> listPage(TSafeRiskMapElementDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskMapElementVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskMapElementVO> iPage = tSafeRiskMapElementDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskMapElementVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskMapElementDO> createQuery(TSafeRiskMapElementDTOParam queryParam){
        QueryWrapper<TSafeRiskMapElementDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getMapId())){
            queryWrapper.eq(TSafeRiskMapElementDO.MAP_ID,queryParam.getMapId());
        }
        if(StringHelper.isNotEmpty(queryParam.getSpaceId())){
            queryWrapper.eq(TSafeRiskMapElementDO.SPACE_ID,queryParam.getSpaceId());
        }
        if(StringHelper.isNotEmpty(queryParam.getLevelType())){
            queryWrapper.eq(TSafeRiskMapElementDO.LEVEL_TYPE,queryParam.getLevelType());
        }
        if(StringHelper.isNotEmpty(queryParam.getRealLevelId())){
            queryWrapper.eq(TSafeRiskMapElementDO.REAL_LEVEL_ID,queryParam.getRealLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getInherentLevelId())){
            queryWrapper.eq(TSafeRiskMapElementDO.INHERENT_LEVEL_ID,queryParam.getInherentLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getDepartmentId())){
            queryWrapper.eq(TSafeRiskMapElementDO.DEPARTMENT_ID,queryParam.getDepartmentId());
        }
        if(StringHelper.isNotEmpty(queryParam.getUserId())){
            queryWrapper.eq(TSafeRiskMapElementDO.USER_ID,queryParam.getUserId());
        }
        if(StringHelper.isNotEmpty(queryParam.getMapJson())){
            queryWrapper.eq(TSafeRiskMapElementDO.MAP_JSON,queryParam.getMapJson());
        }
        if(StringHelper.isNotEmpty(queryParam.getInherentLevelCode())){
            queryWrapper.eq(TSafeRiskMapElementDO.INHERENT_LEVEL_CODE,queryParam.getInherentLevelCode());
        }
        if(StringHelper.isNotEmpty(queryParam.getRealLevelCode())){
            queryWrapper.eq(TSafeRiskMapElementDO.REAL_LEVEL_CODE,queryParam.getRealLevelCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskMapElementDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskMapElementDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskMapElementDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public TSafeRiskMapElementDTO insert(TSafeRiskMapElementDTO riskMapElementDTO){
        TSafeRiskMapElementDO data = BeanHelper.beanToBean(riskMapElementDTO, TSafeRiskMapElementDO.class);
        int result = tSafeRiskMapElementDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskMapElementDTO = BeanHelper.beanToBean(data, TSafeRiskMapElementDTO.class);
        return riskMapElementDTO;
    }
}

