package com.testor.module.accident.model.req;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 事故上报 查询参数对象
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "AccidentReport 列表查询参数对象")
public class AccidentReportQueryReq {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "区域公司id")
	private String regionalCompanyId;

	@ApiModelProperty(value = "基层单位id")
	private String basicUnitId;

	@ApiModelProperty(value = "事故等级")
	private String accidentLevel;

	@ApiModelProperty(value = "流程状态")
	private String processStatus;

	@ApiModelProperty(value = "事件类型")
	private String accidentType;

	@ApiModelProperty(value = "事故开始时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JSONField(format = "yyyy-MM-dd HH:mm:ss")
	private Date accidentStartTime;

	@ApiModelProperty(value = "事故结束时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JSONField(format = "yyyy-MM-dd HH:mm:ss")
	private Date accidentEndTime;

	@ApiModelProperty(value = "单位id")
	private String deptId;

//	@ApiModelProperty(value = "第三层单位")
//	private String thirdLevelUnitId;
}
