package com.testor.module.contractor.common.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商台账和项目台账关系对象 t_contractor_ledger_project
 * 
 * @author testor-framework
 * @date 2024-11-20 20:50:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_ledger_project")
@ApiModel(value = "TContractorLedgerProject对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorLedgerProject extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 承包商id
 */
  @ApiModelProperty(value = "承包商id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("project_id")
  private String projectId;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJECT_ID ="project_id";
  public static final String BIZ_ID ="biz_id";


}
