package com.testor.module.duty.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.constant.IsOrNoEnum;
import com.testor.module.duty.dao.TSysTaskWorkDao;
import com.testor.module.duty.model.domain.TSysTaskWork;
import com.testor.module.duty.service.TSysTaskWorkService;
import com.testor.module.partner.model.domain.TPartnerStaff;
import com.testor.module.partner.service.TPartnerStaffService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 作业活动Service业务层处理
 *
 * @author testor-framework
 * @date 2022-06-08 14:32:32
 */
@Service
public class TSysTaskWorkServiceImpl extends SuperServiceImpl<TSysTaskWorkDao, TSysTaskWork> implements TSysTaskWorkService {
    @Autowired
    private SysOrgService sysOrgService;

    @Autowired
    private TPartnerStaffService staffService;

    @Override
    public String addEntity(TSysTaskWork addRequest) throws Exception{
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        if (Objects.isNull(sysOrg)) {
            throw new BusinessException("当前登录人部门信息不存在，请联系管理员！");
        }
        BaseResponse<TSysTaskWork> baseResponse = new BaseResponse<>();
        String id = "";
        if (ObjectHelper.isNotEmpty(addRequest)) {
            id = addRequest.getId();
            if (StringHelper.isEmpty(id)) {
                id = IdHelper.getId32bit();
            }

            TSysTaskWork data = BeanHelper.beanToBean(addRequest, TSysTaskWork.class);
            data.setCreateDate(new Date());
            data.setCompanyId(sysOrg.getOrgId());
            data.setCreateBy(loginUser.getUserId());
            if ("common".equals(addRequest.getActiveCategory()) || "other".equals(addRequest.getActiveCategory())) {
                data.setIsRiskJob("0");
            } else {
                data.setIsRiskJob("1");
            }
            data.setId(id);
            boolean result = this.saveOrUpdate(data);
//            if (result) {
//                TSysTaskWork newEntity = new TSysTaskWork();
//                newEntity.setId(id);
////                newEntity.setActiveCategory(data.getActiveCategory());
////                newEntity.setIsRiskJob(data.getIsRiskJob());
//                baseResponse.setData(newEntity);
//            }
        }
        return id;
    }

    @Override
    public List<TSysTaskWork> export(QueryWrapper<TSysTaskWork> wrapper) {
        List<TSysTaskWork> tSysTaskWorks = this.list(wrapper);
        if (!CollectionUtils.isEmpty(tSysTaskWorks)) {
            //相关方人员信息
            for (TSysTaskWork tSysTaskWork : tSysTaskWorks) {
                if (StringUtils.isNotBlank(tSysTaskWork.getActiveCategory())) {
                    tSysTaskWork.setActiveCategory("普通作业");
                }

                tSysTaskWork.setIsControlTask(IsOrNoEnum.getName(tSysTaskWork.getIsControlTask()));
                tSysTaskWork.setIsTaskAnalysis(IsOrNoEnum.getName(tSysTaskWork.getIsTaskAnalysis()));
                tSysTaskWork.setIsTaskApproval(IsOrNoEnum.getName(tSysTaskWork.getIsTaskApproval()));
                tSysTaskWork.setIsSkillTell(IsOrNoEnum.getName(tSysTaskWork.getIsSkillTell()));
                tSysTaskWork.setIsInvolve(IsOrNoEnum.getName(tSysTaskWork.getIsInvolve()));
                tSysTaskWork.setIsRiskJob(IsOrNoEnum.getName(tSysTaskWork.getIsRiskJob()));
                tSysTaskWork.setIsElementChange(IsOrNoEnum.getName(tSysTaskWork.getIsElementChange()));
                String s="";
                if (StringUtils.isNotBlank(tSysTaskWork.getInvolvePerson())) {
                    String[] split1 = tSysTaskWork.getInvolvePerson().split(",");
                    if (split1.length>0) {
                        for (int i = 0; i < split1.length; i++) {
                            TPartnerStaff byId = staffService.getById(split1[i]);
                            if (byId!=null) {
                                s=s+byId.getName();
                            }
                        }
                        tSysTaskWork.setInvolvePerson(s);
                    }
                }
            }
        }
        return tSysTaskWorks;
    }
}
