package com.testor.module.hazard.controller;

import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.domain.TrainExaminationManageRetake;
import com.testor.module.hazard.model.dto.THazardWorkPlanDTO;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.testor.module.hazard.service.TrainExaminationManageRetakeService;
import com.testor.module.train.paper.model.domain.TTrainPaper;
import com.testor.module.train.paper.service.TTrainPaperService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/manage/retake")
@Api(value = "TrainExaminationManageRetake", tags = "考试管理—安全培训教育补考")
@Slf4j
public class TrainExaminationManageRetakeController {

    @Autowired
    private TrainExaminationManageRetakeService trainExaminationManageRetakeService;

    @Autowired
    private TTrainPaperService tTrainPaperService;

    @ApiOperation(value = "新增 考试管理—安全培训教育补考", notes = "Add TrainExaminationManageRetake")
    @PostMapping(value = "/insertTrainExaminationManageRetake")
    public BaseResponse<TrainExaminationManageRetake> insertTrainExaminationManageRetake(@RequestBody TrainExaminationManageRetake addRequest) {
        BaseResponse<TrainExaminationManageRetake> baseResponse=new BaseResponse<>();
        if(ObjectHelper.isNotEmpty(addRequest)){
            trainExaminationManageRetakeService.insertTrainExaminationManageRetake(addRequest);
        }
        return baseResponse;
    }


    @ApiOperation(value = "获取 考试管理—安全培训教育补考 ", notes = "Get TrainExaminationManageRetake By Id")
    @GetMapping(value = "/getByTrainExaminationManageId")
    public BaseResponse<TrainExaminationManageRetake> getByTrainExaminationManageId(String id){
        BaseResponse<TrainExaminationManageRetake> baseResponse=new BaseResponse<>();
        if(StringHelper.isNotEmpty(id)){
            // TODO 按需求添加业务异常判断
            TrainExaminationManageRetake data= trainExaminationManageRetakeService.getByTrainExaminationManageId(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 考试管理—安全培训教育补考  ", notes = "Update TrainExaminationManageRetake By Id")
    @PutMapping(value = "/update")
    public BaseResponse<TrainExaminationManageRetake> updateEntity(@RequestBody TrainExaminationManageRetake updateRequest){
        BaseResponse<TrainExaminationManageRetake> baseResponse=new BaseResponse<>();
        if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            trainExaminationManageRetakeService.updateTrainExaminationManageRetake(updateRequest);
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 考试管理—试卷分数 ", notes = "Get TrainExaminationManageRetake By Id")
    @GetMapping(value = "/selectByExaminationManageId")
    public BaseResponse<List<TTrainPaper>> selectByExaminationManageId(String id){
        BaseResponse<List<TTrainPaper>> baseResponse=new BaseResponse<>();
        if(StringHelper.isNotEmpty(id)){
            // TODO 按需求添加业务异常判断
            baseResponse.setData(tTrainPaperService.selectByExaminationManageId(id));
        }
        return baseResponse;
    }

}
