package com.testor.module.hire.entity.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.testor.biz.file.model.dto.FileDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 租赁库管理-附件
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
@Getter
@Setter
@Accessors(chain = true)
public class DepositoryFileInfoVo {

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 租赁库管理id
     */
    private String hireDepositoryManageBaseId;

    /**
     * 准入评分表，
     */
    @ApiModelProperty(value = "准入评分表 数组 ")
    private List<FileDTO> fileScore;

    /**
     * 风险准入证明材料
     */
    @ApiModelProperty(value = "风险准入证明材料 ")
    private List<FileDTO> fileRisk;

    /**
     * 仓储准入证明材料
     */
    @ApiModelProperty(value = "仓储准入证明材料 ")
    private List<FileDTO> fileDepository;

    /**
     * 安环准入证明材料
     */
    @ApiModelProperty(value = "安环准入证明材料 ")
    private List<FileDTO> fileSafety;

    /**
     * 财务准入证明材料
     */
    @ApiModelProperty(value = "财务准入证明材料 ")
    private List<FileDTO> fileFinance;

    /**
     * 人力准入证明材料
     */
    @ApiModelProperty(value = "人力准入证明材料 ")
    private List<FileDTO> filePersion;

    /**
     * 其他准入证明材料
     */
    @ApiModelProperty(value = "其他准入证明材料 ")
    private List<FileDTO> fileOther;

}
