package com.testor.module.partner.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.partner.model.domain.TPartnerOrgRes;
import com.testor.module.partner.model.dto.TPartnerOrgResDTO;
import com.testor.module.partner.model.dto.TPartnerOrgResParam;
import com.testor.module.partner.service.TPartnerOrgResService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 相关方组织负责人Controller
 *
 * @author testor-framework
 * @date 2022-06-27 16:04:14
 */
@RestController
@RequestMapping("/partner/partnerOrgRes")
@Api(value = "TPartnerOrgRes", tags = "相关方组织负责方")
@Slf4j
public class TPartnerOrgResController extends SuperController {
    @Autowired
    private TPartnerOrgResService tPartnerOrgResService;

    @ApiOperation(value = "新增 相关方组织负责方 - L", notes = "Add TPartnerOrgRes")
    @PostMapping(value = "/add")
    public BaseResponse<TPartnerOrgRes> addEntity(@RequestBody TPartnerOrgResDTO addRequest) {
        return tPartnerOrgResService.addOrdRes(addRequest);
    }

    /*@ApiOperation(value = "获取 相关方组织负责人 ", notes = "Get TPartnerOrgRes By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TPartnerOrgRes> getById(String id) {
        BaseResponse<TPartnerOrgRes> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TPartnerOrgRes data = tPartnerOrgResService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }*/

    @ApiOperation(value = "修改 相关方组织负责人 - L", notes = "Update TPartnerOrgRes By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TPartnerOrgResDTO updateRequest) {
        return tPartnerOrgResService.update(updateRequest);
    }

   /* @ApiOperation(value = "删除 相关方组织负责人 ", notes = "delete TPartnerOrgRes By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TPartnerOrgResDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TPartnerOrgRes data = new TPartnerOrgRes();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tPartnerOrgResService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "批量删除相关方组织负责人", notes = "delete TPartnerOrgRes by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TPartnerOrgResDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            *//* 批量删除 *//*
            List<TPartnerOrgRes> tPartnerOrgResList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TPartnerOrgRes data = new TPartnerOrgRes();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tPartnerOrgResList.add(data);
            }
            boolean result = tPartnerOrgResService.updateBatchById(tPartnerOrgResList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "获取 相关方组织负责人 分页列表", notes = "List TPartnerOrgRes with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TPartnerOrgRes>> listEntity(TPartnerOrgResParam param) {
        BaseResponse<BaseResponseList<TPartnerOrgRes>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TPartnerOrgRes> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerOrgRes> queryWrapper = this.createQuery(param);
        Page<TPartnerOrgRes> resultList = tPartnerOrgResService.page(resultPage, queryWrapper);
        BaseResponseList<TPartnerOrgRes> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/

   /* @ApiOperation(value = "获取 相关方组织负责人 列表", notes = "List TPartnerOrgRes all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TPartnerOrgRes>> listAllEntity(TPartnerOrgResParam param) {
        BaseResponse<BaseResponseList<TPartnerOrgRes>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerOrgRes> queryWrapper = this.createQuery(param);
        List<TPartnerOrgRes> resultList = tPartnerOrgResService.list(queryWrapper);
        BaseResponseList<TPartnerOrgRes> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/


    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TPartnerOrgRes> createQuery(TPartnerOrgResParam queryParam) {
        QueryWrapper<TPartnerOrgRes> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TPartnerOrgRes.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTypeId())) {
            queryWrapper.eq(TPartnerOrgRes.TYPE_ID, queryParam.getTypeId());
        }
        if (StringHelper.isNotEmpty(queryParam.getPartnerId())) {
            queryWrapper.eq(TPartnerOrgRes.PARTNER_ID, queryParam.getPartnerId());
        }
        if (StringHelper.isNotEmpty(queryParam.getResponsiblePerson())) {
            queryWrapper.eq(TPartnerOrgRes.RESPONSIBLE_PERSON, queryParam.getResponsiblePerson());
        }
        if (StringHelper.isNotEmpty(queryParam.getPhone())) {
            queryWrapper.eq(TPartnerOrgRes.PHONE, queryParam.getPhone());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getContractStartDate())) {
            queryWrapper.eq(TPartnerOrgRes.CONTRACT_START_DATE, queryParam.getContractStartDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getContractEndDate())) {
            queryWrapper.eq(TPartnerOrgRes.CONTRACT_END_DATE, queryParam.getContractEndDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TPartnerOrgRes.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TPartnerOrgRes.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TPartnerOrgRes.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TPartnerOrgRes.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
